/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.query.QueryErrorClassifier;
import io.confluent.ksql.serde.KsqlSerializationException;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kafka.streams.errors.StreamsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlSerializationClassifier
implements QueryErrorClassifier {
    private static final Logger LOG = LoggerFactory.getLogger(KsqlSerializationClassifier.class);
    private final String queryId;

    public KsqlSerializationClassifier(String queryId) {
        this.queryId = Objects.requireNonNull(queryId, "queryId");
    }

    private boolean hasInternalTopicPrefix(Throwable e) {
        int index = ExceptionUtils.indexOfThrowable((Throwable)e, KsqlSerializationException.class);
        KsqlSerializationException kse = (KsqlSerializationException)ExceptionUtils.getThrowableList((Throwable)e).get(index);
        return kse.getTopic().startsWith("_confluent-ksql-");
    }

    public QueryError.Type classify(Throwable e) {
        QueryError.Type type = QueryError.Type.UNKNOWN;
        if ((e instanceof KsqlSerializationException || e instanceof StreamsException && ExceptionUtils.indexOfThrowable((Throwable)e, KsqlSerializationException.class) != -1) && !this.hasInternalTopicPrefix(e)) {
            type = QueryError.Type.USER;
            LOG.info("Classified error as USER error based on schema mismatch. Query ID: {} Exception: {}", (Object)this.queryId, (Object)e);
        }
        return type;
    }
}

