/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.query.QueryErrorClassifier;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kafka.streams.errors.MissingSourceTopicException;
import org.apache.kafka.streams.errors.StreamsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingTopicClassifier
implements QueryErrorClassifier {
    private static final Logger LOG = LoggerFactory.getLogger(MissingTopicClassifier.class);
    private final String queryId;

    public MissingTopicClassifier(String queryId) {
        this.queryId = Objects.requireNonNull(queryId, "queryId");
    }

    public QueryError.Type classify(Throwable e) {
        QueryError.Type type;
        QueryError.Type type2 = type = e instanceof MissingSourceTopicException || e instanceof StreamsException && ExceptionUtils.indexOfThrowable((Throwable)e, MissingSourceTopicException.class) != -1 ? QueryError.Type.USER : QueryError.Type.UNKNOWN;
        if (type == QueryError.Type.USER) {
            LOG.info("Classified error as USER error based on missing topic. Query ID: {} Exception: {}", (Object)this.queryId, (Object)e);
        }
        return type;
    }
}

