/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.context.QueryLoggerUtil;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.materialization.MaterializationInfo;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.scalablepush.ScalablePushRegistry;
import io.confluent.ksql.execution.streams.KSPlanBuilder;
import io.confluent.ksql.execution.streams.materialization.KsqlMaterializationFactory;
import io.confluent.ksql.execution.streams.materialization.ks.KsMaterializationFactory;
import io.confluent.ksql.execution.streams.metrics.RocksDBMetricsCollector;
import io.confluent.ksql.execution.util.KeyUtil;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.internal.StorageUtilizationMetricsReporter;
import io.confluent.ksql.internal.ThroughputMetricsReporter;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.metrics.ConsumerCollector;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.metrics.ProducerCollector;
import io.confluent.ksql.metrics.StreamsErrorCollector;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.properties.PropertiesUtil;
import io.confluent.ksql.query.AuthorizationClassifier;
import io.confluent.ksql.query.KafkaStreamsBuilder;
import io.confluent.ksql.query.KafkaStreamsBuilderImpl;
import io.confluent.ksql.query.KsqlFunctionClassifier;
import io.confluent.ksql.query.KsqlSerializationClassifier;
import io.confluent.ksql.query.MaterializationProviderBuilderFactory;
import io.confluent.ksql.query.MissingSchemaClassifier;
import io.confluent.ksql.query.MissingSubjectClassifier;
import io.confluent.ksql.query.MissingTopicClassifier;
import io.confluent.ksql.query.QueryErrorClassifier;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.query.RecordTooLargeClassifier;
import io.confluent.ksql.query.RegexClassifier;
import io.confluent.ksql.query.SchemaAuthorizationClassifier;
import io.confluent.ksql.query.TransientQueryQueue;
import io.confluent.ksql.query.TransientQuerySinkProcessor;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.ValueFormat;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.BinPackedPersistentQueryMetadataImpl;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.MetricsTagsUtil;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.PersistentQueryMetadataImpl;
import io.confluent.ksql.util.PushQueryMetadata;
import io.confluent.ksql.util.QueryApplicationId;
import io.confluent.ksql.util.QueryMetadata;
import io.confluent.ksql.util.SandboxedBinPackedPersistentQueryMetadataImpl;
import io.confluent.ksql.util.SandboxedSharedKafkaStreamsRuntimeImpl;
import io.confluent.ksql.util.SharedKafkaStreamsRuntime;
import io.confluent.ksql.util.SharedKafkaStreamsRuntimeImpl;
import io.confluent.ksql.util.TransientQueryMetadata;
import io.vertx.core.impl.ConcurrentHashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.processor.internals.namedtopology.NamedTopology;
import org.apache.kafka.streams.processor.internals.namedtopology.NamedTopologyBuilder;

final class QueryBuilder {
    private static final String KSQL_THREAD_EXCEPTION_UNCAUGHT_LOGGER = "ksql.logger.thread.exception.uncaught";
    private final SessionConfig config;
    private final ProcessingLogContext processingLogContext;
    private final ServiceContext serviceContext;
    private final FunctionRegistry functionRegistry;
    private final KafkaStreamsBuilder kafkaStreamsBuilder;
    private final MaterializationProviderBuilderFactory materializationProviderBuilderFactory;
    private final List<SharedKafkaStreamsRuntime> streams;
    private final boolean real;

    QueryBuilder(SessionConfig config, ProcessingLogContext processingLogContext, ServiceContext serviceContext, FunctionRegistry functionRegistry, List<SharedKafkaStreamsRuntime> streams, boolean real) {
        this(config, processingLogContext, serviceContext, functionRegistry, new KafkaStreamsBuilderImpl(Objects.requireNonNull(serviceContext, "serviceContext").getKafkaClientSupplier()), new MaterializationProviderBuilderFactory(config.getConfig(true), serviceContext, new KsMaterializationFactory(), new KsqlMaterializationFactory(processingLogContext)), streams, real);
    }

    @VisibleForTesting
    QueryBuilder(SessionConfig config, ProcessingLogContext processingLogContext, ServiceContext serviceContext, FunctionRegistry functionRegistry, KafkaStreamsBuilder kafkaStreamsBuilder, MaterializationProviderBuilderFactory materializationProviderBuilderFactory, List<SharedKafkaStreamsRuntime> streams, boolean real) {
        this.config = Objects.requireNonNull(config, "config");
        this.processingLogContext = Objects.requireNonNull(processingLogContext, "processingLogContext");
        this.serviceContext = Objects.requireNonNull(serviceContext, "serviceContext");
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.kafkaStreamsBuilder = Objects.requireNonNull(kafkaStreamsBuilder, "kafkaStreamsBuilder");
        this.materializationProviderBuilderFactory = Objects.requireNonNull(materializationProviderBuilderFactory, "materializationProviderBuilderFactory");
        this.streams = Objects.requireNonNull(streams, "streams");
        this.real = real;
    }

    TransientQueryMetadata buildTransientQuery(String statementText, QueryId queryId, Set<SourceName> sources, ExecutionStep<?> physicalPlan, String planSummary, LogicalSchema schema, OptionalInt limit, Optional<WindowInfo> windowInfo, boolean excludeTombstones, QueryMetadata.Listener listener, StreamsBuilder streamsBuilder, Optional<ImmutableMap<TopicPartition, Long>> endOffsets, MetricCollectors metricCollectors) {
        KsqlConfig ksqlConfig = this.config.getConfig(true);
        String applicationId = QueryApplicationId.build((KsqlConfig)ksqlConfig, (boolean)false, (QueryId)queryId);
        RuntimeBuildContext runtimeBuildContext = this.buildContext(applicationId, queryId, streamsBuilder);
        Map<String, Object> streamsProperties = QueryBuilder.buildStreamsProperties(applicationId, Optional.of(queryId), metricCollectors, this.config.getConfig(true), this.processingLogContext);
        streamsProperties.put("num.standby.replicas", 0);
        Object buildResult = QueryBuilder.buildQueryImplementation(physicalPlan, runtimeBuildContext);
        TransientQueryQueue queue = QueryBuilder.buildTransientQueryQueue(buildResult, limit, excludeTombstones, endOffsets);
        Topology topology = streamsBuilder.build(PropertiesUtil.asProperties(streamsProperties));
        PushQueryMetadata.ResultType resultType = buildResult instanceof KTableHolder ? (windowInfo.isPresent() ? PushQueryMetadata.ResultType.WINDOWED_TABLE : PushQueryMetadata.ResultType.TABLE) : PushQueryMetadata.ResultType.STREAM;
        return new TransientQueryMetadata(statementText, schema, sources, planSummary, queue, queryId, applicationId, topology, this.kafkaStreamsBuilder, streamsProperties, this.config.getOverrides(), ksqlConfig.getLong("ksql.streams.shutdown.timeout.ms"), ksqlConfig.getInt("ksql.query.error.max.queue.size"), resultType, ksqlConfig.getLong("ksql.query.retry.backoff.initial.ms"), ksqlConfig.getLong("ksql.query.retry.backoff.max.ms"), listener, this.processingLogContext.getLoggerFactory());
    }

    private static Optional<MaterializationInfo> getMaterializationInfo(Object result) {
        if (result instanceof KTableHolder) {
            return ((KTableHolder)result).getMaterializationBuilder().map(MaterializationInfo.Builder::build);
        }
        return Optional.empty();
    }

    private static Optional<ScalablePushRegistry> applyScalablePushProcessor(LogicalSchema schema, Object result, Supplier<List<PersistentQueryMetadata>> allPersistentQueries, Map<String, Object> streamsProperties, String sourceApplicationId, KsqlConfig ksqlConfig, KsqlTopic ksqlTopic, ServiceContext serviceContext) {
        if (!ksqlConfig.getBoolean("ksql.query.push.v2.registry.installed").booleanValue()) {
            return Optional.empty();
        }
        boolean isTable = result instanceof KTableHolder;
        Optional<ScalablePushRegistry> registry = ScalablePushRegistry.create(schema, allPersistentQueries, isTable, streamsProperties, ksqlConfig.originals(), sourceApplicationId, ksqlTopic, serviceContext, ksqlConfig);
        return registry;
    }

    PersistentQueryMetadata buildPersistentQueryInDedicatedRuntime(KsqlConfig ksqlConfig, KsqlConstants.PersistentQueryType persistentQueryType, String statementText, QueryId queryId, Optional<DataSource> sinkDataSource, Set<DataSource> sources, ExecutionStep<?> physicalPlan, String planSummary, QueryMetadata.Listener listener, Supplier<List<PersistentQueryMetadata>> allPersistentQueries, StreamsBuilder streamsBuilder, MetricCollectors metricCollectors) {
        KsqlTopic ksqlTopic;
        ValueFormat valueFormat;
        KeyFormat keyFormat;
        LogicalSchema logicalSchema;
        String applicationId = QueryApplicationId.build((KsqlConfig)ksqlConfig, (boolean)true, (QueryId)queryId);
        Map<String, Object> streamsProperties = QueryBuilder.buildStreamsProperties(applicationId, Optional.of(queryId), metricCollectors, this.config.getConfig(true), this.processingLogContext);
        switch (persistentQueryType) {
            case CREATE_SOURCE: {
                DataSource dataSource = (DataSource)Iterables.getOnlyElement(sources);
                logicalSchema = dataSource.getSchema();
                keyFormat = dataSource.getKsqlTopic().getKeyFormat();
                valueFormat = dataSource.getKsqlTopic().getValueFormat();
                ksqlTopic = dataSource.getKsqlTopic();
                break;
            }
            default: {
                logicalSchema = sinkDataSource.get().getSchema();
                keyFormat = sinkDataSource.get().getKsqlTopic().getKeyFormat();
                valueFormat = sinkDataSource.get().getKsqlTopic().getValueFormat();
                ksqlTopic = sinkDataSource.get().getKsqlTopic();
            }
        }
        PhysicalSchema querySchema = PhysicalSchema.from((LogicalSchema)logicalSchema, (SerdeFeatures)keyFormat.getFeatures(), (SerdeFeatures)valueFormat.getFeatures());
        RuntimeBuildContext runtimeBuildContext = this.buildContext(applicationId, queryId, streamsBuilder);
        Object result = QueryBuilder.buildQueryImplementation(physicalPlan, runtimeBuildContext);
        Topology topology = streamsBuilder.build(PropertiesUtil.asProperties(streamsProperties));
        Optional<MaterializationProviderBuilderFactory.MaterializationProviderBuilder> materializationProviderBuilder = QueryBuilder.getMaterializationInfo(result).map(info -> this.materializationProviderBuilderFactory.materializationProviderBuilder((MaterializationInfo)info, querySchema, keyFormat, streamsProperties, applicationId, queryId.toString()));
        Optional<ScalablePushRegistry> scalablePushRegistry = QueryBuilder.applyScalablePushProcessor(querySchema.logicalSchema(), result, allPersistentQueries, streamsProperties, applicationId, ksqlConfig, ksqlTopic, this.serviceContext);
        return new PersistentQueryMetadataImpl(persistentQueryType, statementText, querySchema, sources.stream().map(DataSource::getName).collect(Collectors.toSet()), sinkDataSource, planSummary, queryId, materializationProviderBuilder, applicationId, topology, this.kafkaStreamsBuilder, runtimeBuildContext.getSchemas(), streamsProperties, this.config.getOverrides(), ksqlConfig.getLong("ksql.streams.shutdown.timeout.ms"), this.getConfiguredQueryErrorClassifier(ksqlConfig, applicationId), physicalPlan, ksqlConfig.getInt("ksql.query.error.max.queue.size"), this.getUncaughtExceptionProcessingLogger(queryId), ksqlConfig.getLong("ksql.query.retry.backoff.initial.ms"), ksqlConfig.getLong("ksql.query.retry.backoff.max.ms"), listener, scalablePushRegistry, this.processingLogContext.getLoggerFactory());
    }

    PersistentQueryMetadata buildPersistentQueryInSharedRuntime(KsqlConfig ksqlConfig, KsqlConstants.PersistentQueryType persistentQueryType, String statementText, QueryId queryId, Optional<DataSource> sinkDataSource, Set<DataSource> sources, ExecutionStep<?> physicalPlan, String planSummary, QueryMetadata.Listener listener, Supplier<List<PersistentQueryMetadata>> allPersistentQueries, String applicationId, MetricCollectors metricCollectors) {
        KsqlTopic ksqlTopic;
        ValueFormat valueFormat;
        KeyFormat keyFormat;
        LogicalSchema logicalSchema;
        SharedKafkaStreamsRuntime sharedKafkaStreamsRuntime = this.getKafkaStreamsInstance(applicationId, sources.stream().map(DataSource::getName).collect(Collectors.toSet()), queryId, metricCollectors);
        Map<String, Object> queryOverrides = sharedKafkaStreamsRuntime.getStreamProperties();
        switch (persistentQueryType) {
            case CREATE_SOURCE: {
                DataSource dataSource = (DataSource)Iterables.getOnlyElement(sources);
                logicalSchema = dataSource.getSchema();
                keyFormat = dataSource.getKsqlTopic().getKeyFormat();
                valueFormat = dataSource.getKsqlTopic().getValueFormat();
                ksqlTopic = dataSource.getKsqlTopic();
                break;
            }
            default: {
                logicalSchema = sinkDataSource.get().getSchema();
                keyFormat = sinkDataSource.get().getKsqlTopic().getKeyFormat();
                valueFormat = sinkDataSource.get().getKsqlTopic().getValueFormat();
                ksqlTopic = sinkDataSource.get().getKsqlTopic();
            }
        }
        PhysicalSchema querySchema = PhysicalSchema.from((LogicalSchema)logicalSchema, (SerdeFeatures)keyFormat.getFeatures(), (SerdeFeatures)valueFormat.getFeatures());
        NamedTopologyBuilder namedTopologyBuilder = sharedKafkaStreamsRuntime.getKafkaStreams().newNamedTopologyBuilder(queryId.toString(), PropertiesUtil.asProperties(queryOverrides));
        RuntimeBuildContext runtimeBuildContext = this.buildContext(applicationId, queryId, (StreamsBuilder)namedTopologyBuilder);
        Object result = QueryBuilder.buildQueryImplementation(physicalPlan, runtimeBuildContext);
        NamedTopology topology = namedTopologyBuilder.build();
        Optional<MaterializationInfo> materializationInfo = QueryBuilder.getMaterializationInfo(result);
        Optional<ScalablePushRegistry> scalablePushRegistry = QueryBuilder.applyScalablePushProcessor(querySchema.logicalSchema(), result, allPersistentQueries, queryOverrides, applicationId, ksqlConfig, ksqlTopic, this.serviceContext);
        BinPackedPersistentQueryMetadataImpl binPackedPersistentQueryMetadata = new BinPackedPersistentQueryMetadataImpl(persistentQueryType, statementText, querySchema, sources, planSummary, applicationId, topology, sharedKafkaStreamsRuntime, runtimeBuildContext.getSchemas(), this.config.getOverrides(), queryId, materializationInfo, this.materializationProviderBuilderFactory, physicalPlan, this.getUncaughtExceptionProcessingLogger(queryId), sinkDataSource, listener, scalablePushRegistry, streamsRuntime -> this.getNamedTopology((SharedKafkaStreamsRuntime)streamsRuntime, queryId, applicationId, queryOverrides, physicalPlan), keyFormat, this.processingLogContext.getLoggerFactory());
        if (this.real) {
            return binPackedPersistentQueryMetadata;
        }
        return SandboxedBinPackedPersistentQueryMetadataImpl.of(binPackedPersistentQueryMetadata, listener);
    }

    public NamedTopology getNamedTopology(SharedKafkaStreamsRuntime sharedRuntime, QueryId queryId, String applicationId, Map<String, Object> queryOverrides, ExecutionStep<?> physicalPlan) {
        NamedTopologyBuilder namedTopologyBuilder = sharedRuntime.getKafkaStreams().newNamedTopologyBuilder(queryId.toString(), PropertiesUtil.asProperties(queryOverrides));
        RuntimeBuildContext runtimeBuildContext = this.buildContext(applicationId, queryId, (StreamsBuilder)namedTopologyBuilder);
        QueryBuilder.buildQueryImplementation(physicalPlan, runtimeBuildContext);
        return namedTopologyBuilder.build();
    }

    public static Map<String, Object> buildStreamsProperties(String applicationId, Optional<QueryId> queryId, MetricCollectors metricCollectors, KsqlConfig config, ProcessingLogContext processingLogContext) {
        HashMap<String, Object> newStreamsProperties = new HashMap<String, Object>(config.getKsqlStreamConfigProps(applicationId));
        newStreamsProperties.put("application.id", applicationId);
        String id = queryId.isPresent() ? queryId.get().toString() : applicationId;
        ProcessingLogger logger = processingLogContext.getLoggerFactory().getLogger(id, MetricsTagsUtil.getMetricsTagsWithQueryId((String)id, Collections.emptyMap()));
        newStreamsProperties.put("ksql.logger.production.error", logger);
        QueryBuilder.updateListProperty(newStreamsProperties, StreamsConfig.consumerPrefix((String)"interceptor.classes"), ConsumerCollector.class.getCanonicalName());
        QueryBuilder.updateListProperty(newStreamsProperties, StreamsConfig.producerPrefix((String)"interceptor.classes"), ProducerCollector.class.getCanonicalName());
        QueryBuilder.updateListProperty(newStreamsProperties, "metric.reporters", RocksDBMetricsCollector.class.getName());
        QueryBuilder.updateListProperty(newStreamsProperties, "metric.reporters", StorageUtilizationMetricsReporter.class.getName());
        QueryBuilder.updateListProperty(newStreamsProperties, "metric.reporters", ThroughputMetricsReporter.class.getName());
        if (!queryId.isPresent()) {
            newStreamsProperties.put("__internal.override.topic.prefix__", "_confluent-ksql-" + config.getString("ksql.service.id") + QueryApplicationId.PERSISTENT_QUERY_INDICATOR);
        }
        newStreamsProperties.put("ksql.internal.metric.collectors", metricCollectors);
        newStreamsProperties.put("ksql.metrics.tags.custom", config.getString("ksql.metrics.tags.custom"));
        newStreamsProperties.put("ksql.internal.metrics", metricCollectors.getMetrics());
        newStreamsProperties.put("ksql.internal.streams.error.collector", StreamsErrorCollector.create((String)applicationId, (MetricCollectors)metricCollectors));
        return newStreamsProperties;
    }

    private SharedKafkaStreamsRuntime getKafkaStreamsInstance(String applicationId, Set<SourceName> sources, QueryId queryId, MetricCollectors metricCollectors) {
        for (SharedKafkaStreamsRuntime sharedKafkaStreamsRuntime : this.streams) {
            if (!sharedKafkaStreamsRuntime.getApplicationId().equals(applicationId) && (!sharedKafkaStreamsRuntime.getApplicationId().equals(applicationId + "-validation") || this.real)) continue;
            return sharedKafkaStreamsRuntime;
        }
        KsqlConfig ksqlConfig = this.config.getConfig(true);
        SharedKafkaStreamsRuntime stream = this.real ? new SharedKafkaStreamsRuntimeImpl(this.kafkaStreamsBuilder, this.getConfiguredQueryErrorClassifier(ksqlConfig, applicationId), ksqlConfig.getInt("ksql.query.error.max.queue.size"), ksqlConfig.getLong("ksql.streams.shutdown.timeout.ms"), QueryBuilder.buildStreamsProperties(applicationId, Optional.empty(), metricCollectors, this.config.getConfig(true), this.processingLogContext)) : new SandboxedSharedKafkaStreamsRuntimeImpl(this.kafkaStreamsBuilder, QueryBuilder.buildStreamsProperties(applicationId + "-validation", Optional.empty(), metricCollectors, this.config.getConfig(true), this.processingLogContext));
        this.streams.add(stream);
        return stream;
    }

    private QueryErrorClassifier getConfiguredQueryErrorClassifier(KsqlConfig ksqlConfig, String applicationId) {
        QueryErrorClassifier userErrorClassifiers = new MissingTopicClassifier(applicationId).and(new AuthorizationClassifier(applicationId)).and((QueryErrorClassifier)new KsqlFunctionClassifier(applicationId)).and((QueryErrorClassifier)new RecordTooLargeClassifier(applicationId)).and((QueryErrorClassifier)new MissingSubjectClassifier(applicationId)).and((QueryErrorClassifier)new MissingSchemaClassifier(applicationId)).and((QueryErrorClassifier)new SchemaAuthorizationClassifier(applicationId)).and((QueryErrorClassifier)new KsqlSerializationClassifier(applicationId));
        return QueryBuilder.buildConfiguredClassifiers(ksqlConfig, applicationId).map(arg_0 -> ((QueryErrorClassifier)userErrorClassifiers).and(arg_0)).orElse(userErrorClassifiers);
    }

    private ProcessingLogger getUncaughtExceptionProcessingLogger(QueryId queryId) {
        QueryContext.Stacker stacker = new QueryContext.Stacker().push(new String[]{KSQL_THREAD_EXCEPTION_UNCAUGHT_LOGGER});
        return this.processingLogContext.getLoggerFactory().getLogger(QueryLoggerUtil.queryLoggerName((QueryId)queryId, (QueryContext)stacker.getQueryContext()), MetricsTagsUtil.getMetricsTagsWithQueryId((String)queryId.toString(), Collections.emptyMap()));
    }

    private static TransientQueryQueue buildTransientQueryQueue(Object buildResult, OptionalInt limit, boolean excludeTombstones, Optional<ImmutableMap<TopicPartition, Long>> endOffsets) {
        TransientQueryQueue queue = new TransientQueryQueue(limit);
        if (buildResult instanceof KStreamHolder) {
            KStream kstream = ((KStreamHolder)buildResult).getStream();
            ConcurrentHashSet donePartitions = new ConcurrentHashSet();
            kstream.process(TransientQuerySinkProcessor.supplier(queue, endOffsets, (ConcurrentHashSet<TopicPartition>)donePartitions), new String[0]);
        } else if (buildResult instanceof KTableHolder) {
            KTable ktable = ((KTableHolder)buildResult).getTable();
            KStream stream = ktable.toStream();
            KStream filtered = excludeTombstones ? stream.filter((k, v) -> v != null) : stream;
            filtered.foreach((k, v) -> queue.acceptRow(KeyUtil.asList((Object)k), (GenericRow)v));
        } else {
            throw new IllegalStateException("Unexpected type built from execution plan");
        }
        return queue;
    }

    private static Object buildQueryImplementation(ExecutionStep<?> physicalPlan, RuntimeBuildContext runtimeBuildContext) {
        KSPlanBuilder planBuilder = new KSPlanBuilder(runtimeBuildContext);
        return physicalPlan.build((PlanBuilder)planBuilder);
    }

    private RuntimeBuildContext buildContext(String applicationId, QueryId queryId, StreamsBuilder streamsBuilder) {
        return RuntimeBuildContext.of((StreamsBuilder)streamsBuilder, (KsqlConfig)this.config.getConfig(true), (ServiceContext)this.serviceContext, (ProcessingLogContext)this.processingLogContext, (FunctionRegistry)this.functionRegistry, (String)applicationId, (QueryId)queryId);
    }

    private static Optional<QueryErrorClassifier> buildConfiguredClassifiers(KsqlConfig cfg, String queryId) {
        Map regexPrefixes = cfg.originalsWithPrefix("ksql.error.classifier.regex");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object value : regexPrefixes.values()) {
            String classifier = (String)value;
            builder.add((Object)RegexClassifier.fromConfig(classifier, queryId));
        }
        ImmutableList classifiers = builder.build();
        if (classifiers.isEmpty()) {
            return Optional.empty();
        }
        QueryErrorClassifier combined = (QueryErrorClassifier)Iterables.get((Iterable)classifiers, (int)0);
        for (QueryErrorClassifier classifier : Iterables.skip((Iterable)classifiers, (int)1)) {
            combined = combined.and(classifier);
        }
        return Optional.ofNullable(combined);
    }

    private static void updateListProperty(Map<String, Object> properties, String key, Object value) {
        LinkedList<Object> valueList;
        LinkedList obj = properties.getOrDefault(key, new LinkedList());
        if (obj instanceof String) {
            String asString = (String)((Object)obj);
            valueList = new LinkedList<String>(Arrays.asList(asString.split("\\s*,\\s*")));
        } else if (obj instanceof List) {
            valueList = new LinkedList(obj);
        } else {
            throw new KsqlException("Expecting list or string for property: " + key);
        }
        valueList.add(value);
        properties.put(key, valueList);
    }
}

