/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.query.QueryErrorClassifier;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.streams.errors.StreamsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordTooLargeClassifier
implements QueryErrorClassifier {
    private static final Logger LOG = LoggerFactory.getLogger(RecordTooLargeClassifier.class);
    private final String queryId;

    public RecordTooLargeClassifier(String queryId) {
        this.queryId = Objects.requireNonNull(queryId, "queryId");
    }

    public QueryError.Type classify(Throwable e) {
        QueryError.Type type;
        QueryError.Type type2 = type = e instanceof StreamsException && ExceptionUtils.getRootCause((Throwable)e) instanceof RecordTooLargeException ? QueryError.Type.USER : QueryError.Type.UNKNOWN;
        if (type == QueryError.Type.USER) {
            LOG.info("Classified RecordTooLargeException error as USER error. Query ID: {} Exception: {}. Consider setting ksql.streams.max.request.size property to a higher value.", (Object)this.queryId, (Object)e.getMessage());
        }
        return type;
    }
}

