/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.query.QueryErrorClassifier;
import io.confluent.ksql.schema.registry.SchemaRegistryUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaAuthorizationClassifier
implements QueryErrorClassifier {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaAuthorizationClassifier.class);
    private final String queryId;

    public SchemaAuthorizationClassifier(String queryId) {
        this.queryId = Objects.requireNonNull(queryId, "queryId");
    }

    public QueryError.Type classify(Throwable e) {
        QueryError.Type type;
        QueryError.Type type2 = type = SchemaRegistryUtil.isAuthErrorCode(e) ? QueryError.Type.USER : QueryError.Type.UNKNOWN;
        if (type == QueryError.Type.USER) {
            LOG.info("Classified error as USER error based on missing SR subject access rights. Query ID: {} Exception: {}", (Object)this.queryId, (Object)e);
        }
        return type;
    }
}

