/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.query;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.query.TransientQueryQueue;
import io.vertx.core.impl.ConcurrentHashSet;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.StreamTask;

final class TransientQuerySinkProcessor
implements Processor<Object, GenericRow, Void, Void> {
    private final TransientQueryQueue queue;
    private final Optional<ImmutableMap<TopicPartition, Long>> endOffsets;
    private final ConcurrentHashSet<TopicPartition> donePartitions;
    private ProcessorContext<Void, Void> context;

    public static ProcessorSupplier<Object, GenericRow, Void, Void> supplier(TransientQueryQueue queue, Optional<ImmutableMap<TopicPartition, Long>> endOffsets, ConcurrentHashSet<TopicPartition> donePartitions) {
        return () -> new TransientQuerySinkProcessor(queue, endOffsets, donePartitions);
    }

    private TransientQuerySinkProcessor(TransientQueryQueue queue, Optional<ImmutableMap<TopicPartition, Long>> endOffsets, ConcurrentHashSet<TopicPartition> donePartitions) {
        this.queue = queue;
        this.endOffsets = endOffsets;
        this.donePartitions = donePartitions;
    }

    public void init(ProcessorContext<Void, Void> context) {
        super.init(context);
        this.context = context;
        if (this.endOffsets.isPresent()) {
            context.schedule(Duration.ofMillis(100L), PunctuationType.WALL_CLOCK_TIME, timestamp -> this.checkForQueryCompletion());
        }
    }

    public void process(Record<Object, GenericRow> record) {
        boolean alreadyDone;
        Optional<TopicPartition> topicPartition = this.context.recordMetadata().map(m -> new TopicPartition(m.topic(), m.partition()));
        boolean bl = alreadyDone = topicPartition.isPresent() && this.donePartitions.contains((Object)topicPartition.get());
        if (record.value() != null && !alreadyDone) {
            this.queue.acceptRow(null, (GenericRow)record.value());
        }
        topicPartition.ifPresent(this::checkForPartitionCompletion);
    }

    private void checkForPartitionCompletion(TopicPartition topicPartition) {
        ImmutableMap<TopicPartition, Long> endOffsetsMap;
        if (this.endOffsets.isPresent() && (endOffsetsMap = this.endOffsets.get()).containsKey((Object)topicPartition)) {
            Map<TopicPartition, OffsetAndMetadata> currentPositions = this.getCurrentPositions();
            this.checkCompletion(topicPartition, currentPositions, (Long)endOffsetsMap.get((Object)topicPartition));
        }
    }

    private void checkForQueryCompletion() {
        if (this.endOffsets.isPresent()) {
            Map<TopicPartition, OffsetAndMetadata> currentPositions = this.getCurrentPositions();
            for (Map.Entry end : this.endOffsets.get().entrySet()) {
                this.checkCompletion((TopicPartition)end.getKey(), currentPositions, (Long)end.getValue());
            }
            if (ImmutableSet.copyOf(this.donePartitions).equals((Object)this.endOffsets.get().keySet())) {
                this.queue.complete();
            }
        }
    }

    private void checkCompletion(TopicPartition topicPartition, Map<TopicPartition, OffsetAndMetadata> currentPositions, Long end) {
        OffsetAndMetadata current;
        if (currentPositions.containsKey(topicPartition) && (current = currentPositions.get(topicPartition)) != null && current.offset() >= end) {
            this.donePartitions.add((Object)topicPartition);
        }
    }

    private Map<TopicPartition, OffsetAndMetadata> getCurrentPositions() {
        try {
            if (this.context.getClass().equals(ProcessorContextImpl.class)) {
                Field streamTask = ProcessorContextImpl.class.getDeclaredField("streamTask");
                streamTask.setAccessible(true);
                StreamTask task = (StreamTask)streamTask.get(this.context);
                Method committableOffsetsAndMetadata = StreamTask.class.getDeclaredMethod("committableOffsetsAndMetadata", new Class[0]);
                committableOffsetsAndMetadata.setAccessible(true);
                return (Map)committableOffsetsAndMetadata.invoke((Object)task, new Object[0]);
            }
            throw new IllegalStateException("Expected only to run in the KafkaStreams or TopologyTestDriver runtimes.");
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

