/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.inference;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.SerdeFeatures;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface TopicSchemaSupplier {
    public SchemaResult getKeySchema(Optional<String> var1, Optional<Integer> var2, FormatInfo var3, SerdeFeatures var4);

    public SchemaResult getValueSchema(Optional<String> var1, Optional<Integer> var2, FormatInfo var3, SerdeFeatures var4);

    public static final class SchemaResult {
        final Optional<SchemaAndId> schemaAndId;
        final Optional<Exception> failureReason;

        private SchemaResult(Optional<SchemaAndId> schemaAndId, Optional<Exception> failureReason) {
            this.schemaAndId = Objects.requireNonNull(schemaAndId, "schemaAndId");
            this.failureReason = Objects.requireNonNull(failureReason, "failureReason");
        }

        static SchemaResult success(SchemaAndId schemaAndId) {
            return new SchemaResult(Optional.of(schemaAndId), Optional.empty());
        }

        static SchemaResult failure(Exception cause) {
            return new SchemaResult(Optional.empty(), Optional.of(cause));
        }

        public Optional<SchemaAndId> getSchemaAndId() {
            return this.schemaAndId;
        }

        public Optional<Exception> getFailureReason() {
            return this.failureReason;
        }
    }

    public static final class SchemaAndId {
        final int id;
        final List<? extends SimpleColumn> columns;
        final ParsedSchema rawSchema;

        private SchemaAndId(List<? extends SimpleColumn> columns, ParsedSchema rawSchema, int id) {
            this.id = id;
            this.rawSchema = rawSchema;
            this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns"));
        }

        static SchemaAndId schemaAndId(List<? extends SimpleColumn> columns, ParsedSchema rawSchema, int id) {
            return new SchemaAndId(columns, rawSchema, id);
        }
    }
}

