/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.registry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.ksql.schema.registry.DefaultSchemaRegistryClient;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.utils.SecurityUtils;

public class KsqlSchemaRegistryClientFactory {
    private final SSLContext sslContext;
    private final Supplier<RestService> serviceSupplier;
    private final Map<String, Object> schemaRegistryClientConfigs;
    private final SchemaRegistryClientFactory schemaRegistryClientFactory;
    private final Map<String, String> httpHeaders;
    private final String schemaRegistryUrl;

    public KsqlSchemaRegistryClientFactory(KsqlConfig config, Map<String, String> schemaRegistryHttpHeaders) {
        this(config, KsqlSchemaRegistryClientFactory.newSslContext(config), schemaRegistryHttpHeaders);
    }

    public KsqlSchemaRegistryClientFactory(KsqlConfig config, SSLContext sslContext, Map<String, String> schemaRegistryHttpHeaders) {
        this(config, () -> new RestService(config.getString("ksql.schema.registry.url")), sslContext, CachedSchemaRegistryClient::new, schemaRegistryHttpHeaders);
        config.getString("ksql.schema.registry.url");
    }

    @VisibleForTesting
    KsqlSchemaRegistryClientFactory(KsqlConfig config, Supplier<RestService> serviceSupplier, SSLContext sslContext, SchemaRegistryClientFactory schemaRegistryClientFactory, Map<String, String> httpHeaders) {
        this.sslContext = sslContext;
        this.serviceSupplier = serviceSupplier;
        this.schemaRegistryClientConfigs = config.originalsWithPrefix("ksql.schema.registry.");
        this.schemaRegistryClientFactory = schemaRegistryClientFactory;
        this.httpHeaders = httpHeaders;
        this.schemaRegistryUrl = config.getString("ksql.schema.registry.url").trim();
    }

    public static SSLContext newSslContext(KsqlConfig config) {
        if (config.getBoolean("enable.fips").booleanValue()) {
            SecurityUtils.addConfiguredSecurityProviders((Map)config.originals());
        }
        DefaultSslEngineFactory sslFactory = new DefaultSslEngineFactory();
        KsqlSchemaRegistryClientFactory.configureSslEngineFactory(config, (SslEngineFactory)sslFactory);
        return sslFactory.sslContext();
    }

    @VisibleForTesting
    static void configureSslEngineFactory(KsqlConfig config, SslEngineFactory sslFactory) {
        sslFactory.configure(config.valuesWithPrefixOverride("ksql.schema.registry."));
    }

    public SchemaRegistryClient get() {
        if (this.schemaRegistryUrl.equals("")) {
            return new DefaultSchemaRegistryClient();
        }
        RestService restService = this.serviceSupplier.get();
        CachedSchemaRegistryClient client = this.schemaRegistryClientFactory.create(restService, 1000, (List<SchemaProvider>)ImmutableList.of((Object)new AvroSchemaProvider(), (Object)new ProtobufSchemaProvider(), (Object)new JsonSchemaProvider()), this.schemaRegistryClientConfigs, this.httpHeaders);
        if (this.sslContext != null) {
            restService.setSslSocketFactory(this.sslContext.getSocketFactory());
        }
        return client;
    }

    static interface SchemaRegistryClientFactory {
        public CachedSchemaRegistryClient create(RestService var1, int var2, List<SchemaProvider> var3, Map<String, Object> var4, Map<String, String> var5);
    }
}

