/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.properties.with.CreateSourceAsProperties;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.CreateAsSelect;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.InsertInto;
import io.confluent.ksql.parser.tree.PrintTopic;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.security.KsqlAccessValidator;
import io.confluent.ksql.security.KsqlAuthorizationValidator;
import io.confluent.ksql.security.KsqlSecurityContext;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.ValueFormat;
import io.confluent.ksql.topic.SourceTopicsExtractor;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.acl.AclOperation;

public class KsqlAuthorizationValidatorImpl
implements KsqlAuthorizationValidator {
    private final KsqlAccessValidator accessValidator;

    public KsqlAuthorizationValidatorImpl(KsqlAccessValidator accessValidator) {
        this.accessValidator = accessValidator;
    }

    KsqlAccessValidator getAccessValidator() {
        return this.accessValidator;
    }

    @Override
    public void checkAuthorization(KsqlSecurityContext securityContext, MetaStore metaStore, Statement statement) {
        if (statement instanceof Query) {
            this.validateQuery(securityContext, metaStore, (Query)statement);
        } else if (statement instanceof InsertInto) {
            this.validateInsertInto(securityContext, metaStore, (InsertInto)statement);
        } else if (statement instanceof CreateAsSelect) {
            this.validateCreateAsSelect(securityContext, metaStore, (CreateAsSelect)statement);
        } else if (statement instanceof PrintTopic) {
            this.validatePrintTopic(securityContext, (PrintTopic)statement);
        } else if (statement instanceof CreateSource) {
            this.validateCreateSource(securityContext, (CreateSource)statement);
        }
    }

    private void validateQuery(KsqlSecurityContext securityContext, MetaStore metaStore, Query query) {
        for (KsqlTopic ksqlTopic : this.extractQueryTopics(query, metaStore)) {
            this.checkTopicAccess(securityContext, ksqlTopic.getKafkaTopicName(), AclOperation.READ);
            this.checkSchemaAccess(securityContext, ksqlTopic, AclOperation.READ);
        }
    }

    private void validateCreateAsSelect(KsqlSecurityContext securityContext, MetaStore metaStore, CreateAsSelect createAsSelect) {
        this.validateQuery(securityContext, metaStore, createAsSelect.getQuery());
        KsqlTopic sinkTopic = this.getCreateAsSelectSinkTopic(metaStore, createAsSelect);
        this.checkTopicAccess(securityContext, sinkTopic.getKafkaTopicName(), AclOperation.WRITE);
        this.checkSchemaAccess(securityContext, sinkTopic, AclOperation.WRITE);
    }

    private void validateInsertInto(KsqlSecurityContext securityContext, MetaStore metaStore, InsertInto insertInto) {
        this.validateQuery(securityContext, metaStore, insertInto.getQuery());
        String kafkaTopic = this.getSourceTopicName(metaStore, insertInto.getTarget());
        this.checkTopicAccess(securityContext, kafkaTopic, AclOperation.WRITE);
    }

    private void validatePrintTopic(KsqlSecurityContext securityContext, PrintTopic printTopic) {
        this.checkTopicAccess(securityContext, printTopic.getTopic(), AclOperation.READ);
    }

    private void validateCreateSource(KsqlSecurityContext securityContext, CreateSource createSource) {
        String sourceTopic = createSource.getProperties().getKafkaTopic();
        this.checkTopicAccess(securityContext, sourceTopic, AclOperation.READ);
    }

    private String getSourceTopicName(MetaStore metaStore, SourceName streamOrTable) {
        DataSource dataSource = metaStore.getSource(streamOrTable);
        if (dataSource == null) {
            throw new KsqlException("Cannot validate for topic access from an unknown stream/table: " + streamOrTable);
        }
        return dataSource.getKafkaTopicName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KsqlTopic getCreateAsSelectSinkTopic(MetaStore metaStore, CreateAsSelect createAsSelect) {
        ValueFormat sinkValueFormat;
        KeyFormat sinkKeyFormat;
        String sinkTopicName;
        CreateSourceAsProperties properties = createAsSelect.getProperties();
        if (!properties.getKafkaTopic().isPresent()) {
            DataSource dataSource = metaStore.getSource(createAsSelect.getName());
            if (dataSource == null) throw new KsqlException("Cannot validate for topic access from an unknown stream/table: " + createAsSelect.getName());
            sinkTopicName = dataSource.getKafkaTopicName();
            sinkKeyFormat = dataSource.getKsqlTopic().getKeyFormat();
            sinkValueFormat = dataSource.getKsqlTopic().getValueFormat();
            return new KsqlTopic(sinkTopicName, sinkKeyFormat, sinkValueFormat);
        } else {
            sinkTopicName = (String)properties.getKafkaTopic().get();
            SourceTopicsExtractor extractor = new SourceTopicsExtractor(metaStore);
            extractor.process((AstNode)createAsSelect.getQuery(), null);
            KsqlTopic primaryKsqlTopic = extractor.getPrimarySourceTopic();
            Optional<Format> keyFormat = properties.getKeyFormat().map(formatName -> FormatFactory.fromName((String)formatName));
            Optional<Format> valueFormat = properties.getValueFormat().map(formatName -> FormatFactory.fromName((String)formatName));
            sinkKeyFormat = keyFormat.map(format -> KeyFormat.of((FormatInfo)FormatInfo.of((String)format.name()), (SerdeFeatures)(format.supportsFeature(SerdeFeature.SCHEMA_INFERENCE) ? SerdeFeatures.of((SerdeFeature[])new SerdeFeature[]{SerdeFeature.SCHEMA_INFERENCE}) : SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0])), Optional.empty())).orElse(primaryKsqlTopic.getKeyFormat());
            sinkValueFormat = valueFormat.map(format -> ValueFormat.of((FormatInfo)FormatInfo.of((String)format.name()), (SerdeFeatures)(format.supportsFeature(SerdeFeature.SCHEMA_INFERENCE) ? SerdeFeatures.of((SerdeFeature[])new SerdeFeature[]{SerdeFeature.SCHEMA_INFERENCE}) : SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0])))).orElse(primaryKsqlTopic.getValueFormat());
        }
        return new KsqlTopic(sinkTopicName, sinkKeyFormat, sinkValueFormat);
    }

    private Set<KsqlTopic> extractQueryTopics(Query query, MetaStore metaStore) {
        SourceTopicsExtractor extractor = new SourceTopicsExtractor(metaStore);
        extractor.process((AstNode)query, null);
        return extractor.getSourceTopics();
    }

    private void checkTopicAccess(KsqlSecurityContext securityContext, String resourceName, AclOperation operation) {
        this.accessValidator.checkTopicAccess(securityContext, resourceName, operation);
    }

    private void checkSchemaAccess(KsqlSecurityContext securityContext, KsqlTopic ksqlTopic, AclOperation operation) {
        if (KsqlAuthorizationValidatorImpl.formatSupportsSchemaInference(ksqlTopic.getKeyFormat().getFormatInfo())) {
            this.accessValidator.checkSubjectAccess(securityContext, KsqlConstants.getSRSubject((String)ksqlTopic.getKafkaTopicName(), (boolean)true), operation);
        }
        if (KsqlAuthorizationValidatorImpl.formatSupportsSchemaInference(ksqlTopic.getValueFormat().getFormatInfo())) {
            this.accessValidator.checkSubjectAccess(securityContext, KsqlConstants.getSRSubject((String)ksqlTopic.getKafkaTopicName(), (boolean)false), operation);
        }
    }

    private static boolean formatSupportsSchemaInference(FormatInfo format) {
        return FormatFactory.of((FormatInfo)format).supportsFeature(SerdeFeature.SCHEMA_INFERENCE);
    }
}

