/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class SerdeFeaturesFactory {
    private SerdeFeaturesFactory() {
    }

    public static SerdeFeatures buildInternal(Format keyFormat) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        SerdeFeaturesFactory.getKeyWrapping(true, keyFormat).ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return SerdeFeatures.from((Set)builder.build());
    }

    public static SerdeFeatures buildKeyFeatures(LogicalSchema schema, Format keyFormat) {
        return SerdeFeaturesFactory.buildKeyFeatures(keyFormat, schema.key().size() == 1);
    }

    public static SerdeFeatures buildKeyFeatures(Format keyFormat, boolean isSingleKey) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        SerdeFeaturesFactory.getKeyWrapping(isSingleKey, keyFormat).ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return SerdeFeatures.from((Set)builder.build());
    }

    public static SerdeFeatures buildValueFeatures(LogicalSchema schema, Format valueFormat, SerdeFeatures explicitFeatures, KsqlConfig ksqlConfig) {
        boolean singleColumn = schema.value().size() == 1;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        SerdeFeaturesFactory.getValueWrapping(singleColumn, valueFormat, explicitFeatures, ksqlConfig).ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return SerdeFeatures.from((Set)builder.build());
    }

    public static KeyFormat sanitizeKeyFormat(KeyFormat keyFormat, List<SqlType> newKeyColumnSqlTypes, boolean allowKeyFormatChangeToSupportNewKeySchema) {
        return SerdeFeaturesFactory.sanitizeKeyFormatWrapping(!allowKeyFormatChangeToSupportNewKeySchema ? keyFormat : SerdeFeaturesFactory.sanitizeKeyFormatForTypeCompatibility(SerdeFeaturesFactory.sanitizeKeyFormatForMultipleColumns(keyFormat, newKeyColumnSqlTypes.size()), newKeyColumnSqlTypes), newKeyColumnSqlTypes.size() == 1);
    }

    private static KeyFormat sanitizeKeyFormatForMultipleColumns(KeyFormat keyFormat, int numKeyColumns) {
        if (numKeyColumns <= 1 || SerdeFeaturesFactory.formatSupportsMultipleColumns(keyFormat)) {
            return keyFormat;
        }
        return SerdeFeaturesFactory.convertToJsonFormat(keyFormat);
    }

    private static KeyFormat sanitizeKeyFormatForTypeCompatibility(KeyFormat keyFormat, List<SqlType> sqlTypes) {
        return sqlTypes.stream().allMatch(sqlType -> FormatFactory.of((FormatInfo)keyFormat.getFormatInfo()).supportsKeyType(sqlType)) ? keyFormat : SerdeFeaturesFactory.convertToJsonFormat(keyFormat);
    }

    private static KeyFormat convertToJsonFormat(KeyFormat keyFormat) {
        if (keyFormat.isWindowed()) {
            throw new IllegalStateException("Should not convert format of windowed key");
        }
        return KeyFormat.nonWindowed((FormatInfo)FormatInfo.of((String)"JSON"), (SerdeFeatures)SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]));
    }

    private static KeyFormat sanitizeKeyFormatWrapping(KeyFormat keyFormat, boolean isSingleKey) {
        Optional keyWrapping = keyFormat.getFeatures().findAny((Set)SerdeFeatures.WRAPPING_FEATURES);
        boolean hasWrappingFeature = keyWrapping.isPresent();
        if (isSingleKey && !hasWrappingFeature) {
            SerdeFeatures defaultWrapping = SerdeFeaturesFactory.getKeyWrapping(true, FormatFactory.of((FormatInfo)keyFormat.getFormatInfo())).map(xva$0 -> SerdeFeatures.of((SerdeFeature[])new SerdeFeature[]{xva$0})).orElse(SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]));
            return keyFormat.withSerdeFeatures(defaultWrapping);
        }
        if (!isSingleKey && hasWrappingFeature) {
            return keyFormat.withoutSerdeFeatures(SerdeFeatures.of((SerdeFeature[])new SerdeFeature[]{(SerdeFeature)keyWrapping.get()}));
        }
        return keyFormat;
    }

    private static Optional<SerdeFeature> getKeyWrapping(boolean singleKey, Format keyFormat) {
        if (singleKey && keyFormat.supportsFeature(SerdeFeature.UNWRAP_SINGLES) && keyFormat.supportsFeature(SerdeFeature.WRAP_SINGLES)) {
            return Optional.of(SerdeFeature.UNWRAP_SINGLES);
        }
        return Optional.empty();
    }

    private static Optional<SerdeFeature> getValueWrapping(boolean singleColumn, Format valueFormat, SerdeFeatures explicitFeatures, KsqlConfig ksqlConfig) {
        Optional valueWrapping = explicitFeatures.findAny((Set)SerdeFeatures.WRAPPING_FEATURES);
        if (valueWrapping.isPresent()) {
            SerdeFeaturesFactory.validateExplicitValueWrapping(singleColumn, valueFormat, (SerdeFeature)valueWrapping.get());
            return valueWrapping;
        }
        return SerdeFeaturesFactory.getDefaultValueWrapping(singleColumn, valueFormat, ksqlConfig);
    }

    private static void validateExplicitValueWrapping(boolean singleColumn, Format valueFormat, SerdeFeature wrappingFeature) {
        if (!valueFormat.supportedFeatures().contains(wrappingFeature)) {
            boolean value = wrappingFeature == SerdeFeature.WRAP_SINGLES;
            throw new KsqlException("Format '" + valueFormat.name() + "' does not support '" + "WRAP_SINGLE_VALUE" + "' set to '" + value + "'.");
        }
        if (!singleColumn) {
            throw new KsqlException("'WRAP_SINGLE_VALUE' is only valid for single-field value schemas");
        }
    }

    private static Optional<SerdeFeature> getDefaultValueWrapping(boolean singleColumn, Format valueFormat, KsqlConfig ksqlConfig) {
        SerdeFeature feature;
        if (!singleColumn) {
            return Optional.empty();
        }
        Boolean valueWrapping = ksqlConfig.getBoolean("ksql.persistence.wrap.single.values");
        if (valueWrapping == null) {
            return Optional.empty();
        }
        SerdeFeature serdeFeature = feature = valueWrapping != false ? SerdeFeature.WRAP_SINGLES : SerdeFeature.UNWRAP_SINGLES;
        if (!valueFormat.supportsFeature(feature)) {
            return Optional.empty();
        }
        return Optional.of(feature);
    }

    private static boolean formatSupportsMultipleColumns(KeyFormat format) {
        return !format.getFormat().equals("KAFKA") && !format.getFormat().equals("NONE");
    }
}

