/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.schema.registry.KsqlSchemaRegistryClientFactory;
import io.confluent.ksql.security.KsqlPrincipal;
import io.confluent.ksql.services.ConnectClient;
import io.confluent.ksql.services.DefaultConnectClientFactory;
import io.confluent.ksql.services.DefaultServiceContext;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.services.SimpleKsqlClient;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolCommand;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;

public final class ServiceContextFactory {
    private ServiceContextFactory() {
    }

    public static ServiceContext create(KsqlConfig ksqlConfig, Supplier<SimpleKsqlClient> ksqlClientSupplier) {
        return ServiceContextFactory.create(ksqlConfig, (KafkaClientSupplier)new DefaultKafkaClientSupplier(), new KsqlSchemaRegistryClientFactory(ksqlConfig, Collections.emptyMap())::get, () -> new DefaultConnectClientFactory(ksqlConfig).get(Optional.empty(), Collections.emptyList(), Optional.empty()), ksqlClientSupplier, Optional.empty());
    }

    public static ServiceContext create(KsqlConfig ksqlConfig, KafkaClientSupplier kafkaClientSupplier, Supplier<SchemaRegistryClient> srClientFactory, Supplier<ConnectClient> connectClientSupplier, Supplier<SimpleKsqlClient> ksqlClientSupplier, Optional<KsqlPrincipal> userPrincipal) {
        Supplier<Admin> topicAdminClientSupplier;
        if (ksqlConfig.getBoolean("ksql.client.ip_port.configuration.enabled").booleanValue() && userPrincipal.isPresent()) {
            HashMap<String, Object> topicAdminConfig = new HashMap<String, Object>(ksqlConfig.getKsqlAdminClientConfigProps());
            topicAdminConfig.put("confluent.proxy.protocol.client.mode", ProxyProtocolCommand.PROXY.name());
            topicAdminConfig.put("confluent.proxy.protocol.client.address", userPrincipal.get().getIpAddress());
            topicAdminConfig.put("confluent.proxy.protocol.client.port", userPrincipal.get().getPort());
            topicAdminConfig.put("confluent.proxy.protocol.client.version", ProxyProtocol.V2.name);
            topicAdminClientSupplier = () -> kafkaClientSupplier.getAdmin(topicAdminConfig);
        } else {
            topicAdminClientSupplier = () -> kafkaClientSupplier.getAdmin(ksqlConfig.getKsqlAdminClientConfigProps());
        }
        return new DefaultServiceContext(kafkaClientSupplier, () -> kafkaClientSupplier.getAdmin(ksqlConfig.getKsqlAdminClientConfigProps()), topicAdminClientSupplier, srClientFactory, connectClientSupplier, ksqlClientSupplier);
    }
}

