/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.statement;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Map;
import java.util.Objects;

@Immutable
public final class ConfiguredStatement<T extends Statement> {
    private final KsqlParser.PreparedStatement<T> statement;
    private final SessionConfig config;

    public static <S extends Statement> ConfiguredStatement<S> of(KsqlParser.PreparedStatement<S> statement, SessionConfig config) {
        return new ConfiguredStatement<S>(statement, config);
    }

    private ConfiguredStatement(KsqlParser.PreparedStatement<T> statement, SessionConfig config) {
        this.statement = Objects.requireNonNull(statement, "statement");
        this.config = Objects.requireNonNull(config, "config");
    }

    public <S extends Statement> ConfiguredStatement<S> cast() {
        return this;
    }

    public KsqlParser.PreparedStatement<T> getPreparedStatement() {
        return this.statement;
    }

    public T getStatement() {
        return (T)this.statement.getStatement();
    }

    public String getMaskedStatementText() {
        return this.statement.getMaskedStatementText();
    }

    public String getUnMaskedStatementText() {
        return this.statement.getUnMaskedStatementText();
    }

    public SessionConfig getSessionConfig() {
        return this.config;
    }

    public ConfiguredStatement<T> withConfig(KsqlConfig config) {
        SessionConfig newConfig = SessionConfig.of((KsqlConfig)config, (Map)this.config.getOverrides());
        return new ConfiguredStatement<T>(this.statement, newConfig);
    }

    public ConfiguredStatement<T> withConfigOverrides(Map<String, Object> properties) {
        SessionConfig newConfig = SessionConfig.of((KsqlConfig)this.config.getConfig(false), properties);
        return new ConfiguredStatement<T>(this.statement, newConfig);
    }

    public ConfiguredStatement<T> withStatement(String statementText, T statement) {
        return new ConfiguredStatement<T>(KsqlParser.PreparedStatement.of((String)statementText, statement), this.config);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfiguredStatement that = (ConfiguredStatement)o;
        return Objects.equals(this.statement, that.statement) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.statement, this.config);
    }

    public String toString() {
        return "ConfiguredStatement{statement=" + this.statement + ", config=" + this.config + '}';
    }
}

