/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.statement;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.Injector;
import io.confluent.ksql.statement.InjectorWithSideEffects;
import java.util.ArrayList;
import java.util.List;

public final class InjectorChain
implements InjectorWithSideEffects {
    private final List<Injector> injectors;

    public static InjectorChain of(Injector ... injectors) {
        return new InjectorChain(injectors);
    }

    private InjectorChain(Injector ... injectors) {
        this.injectors = ImmutableList.copyOf((Object[])injectors);
    }

    @Override
    public <T extends Statement> ConfiguredStatement<T> inject(ConfiguredStatement<T> statement) {
        ConfiguredStatement<T> injected = statement;
        for (Injector injector : this.injectors) {
            injected = injector.inject(injected);
        }
        return injected;
    }

    @Override
    public <T extends Statement> InjectorWithSideEffects.ConfiguredStatementWithSideEffects<T> injectWithSideEffects(ConfiguredStatement<T> statement) {
        ConfiguredStatement<T> injected = statement;
        ArrayList<Object> allSideEffects = new ArrayList<Object>();
        for (Injector injector : this.injectors) {
            if (injector instanceof InjectorWithSideEffects) {
                InjectorWithSideEffects.ConfiguredStatementWithSideEffects<T> wse = ((InjectorWithSideEffects)injector).injectWithSideEffects(injected);
                injected = wse.getStatement();
                allSideEffects.addAll(wse.getSideEffects());
                continue;
            }
            injected = injector.inject(injected);
        }
        return new InjectorWithSideEffects.ConfiguredStatementWithSideEffects<T>(injected, allSideEffects);
    }

    @Override
    public <T extends Statement> void revertSideEffects(InjectorWithSideEffects.ConfiguredStatementWithSideEffects<T> statement) {
        for (Injector injector : this.injectors) {
            if (!(injector instanceof InjectorWithSideEffects)) continue;
            ((InjectorWithSideEffects)injector).revertSideEffects(statement);
        }
    }
}

