/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.statement;

import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.SqlFormatter;
import io.confluent.ksql.parser.properties.with.CreateSourceAsProperties;
import io.confluent.ksql.parser.properties.with.CreateSourceProperties;
import io.confluent.ksql.parser.tree.CreateAsSelect;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.Injector;
import io.confluent.ksql.util.ErrorMessageUtil;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlStatementException;

public class SourcePropertyInjector
implements Injector {
    @Override
    public <T extends Statement> ConfiguredStatement<T> inject(ConfiguredStatement<T> statement) {
        if (!(statement.getStatement() instanceof CreateSource) && !(statement.getStatement() instanceof CreateAsSelect)) {
            return statement;
        }
        try {
            if (statement.getStatement() instanceof CreateAsSelect) {
                return this.injectForCreateAsSelect(statement);
            }
            return this.injectForCreateSource(statement);
        }
        catch (KsqlStatementException e) {
            throw e;
        }
        catch (KsqlException e) {
            throw new KsqlStatementException(ErrorMessageUtil.buildErrorMessage((Throwable)e), statement.getMaskedStatementText(), e.getCause());
        }
    }

    private ConfiguredStatement<? extends CreateSource> injectForCreateSource(ConfiguredStatement<? extends CreateSource> original) {
        CreateSource statement = original.getStatement();
        CreateSourceProperties properties = statement.getProperties();
        CreateSourceProperties injectedProps = properties.withUnwrapProtobufPrimitives(true);
        return SourcePropertyInjector.buildConfiguredStatement(original, injectedProps);
    }

    private ConfiguredStatement<? extends CreateAsSelect> injectForCreateAsSelect(ConfiguredStatement<? extends CreateAsSelect> original) {
        CreateAsSelect createAsSelect = original.getStatement();
        CreateSourceAsProperties properties = createAsSelect.getProperties();
        CreateSourceAsProperties injectedProps = properties.withUnwrapProtobufPrimitives(true);
        return SourcePropertyInjector.buildConfiguredStatement(original, injectedProps);
    }

    private static ConfiguredStatement<CreateSource> buildConfiguredStatement(ConfiguredStatement<? extends CreateSource> original, CreateSourceProperties injectedProps) {
        CreateSource statement = original.getStatement();
        CreateSource withProps = statement.copyWith(original.getStatement().getElements(), injectedProps);
        KsqlParser.PreparedStatement<CreateSource> prepared = SourcePropertyInjector.buildPreparedStatement(withProps);
        return ConfiguredStatement.of(prepared, original.getSessionConfig());
    }

    private static ConfiguredStatement<CreateAsSelect> buildConfiguredStatement(ConfiguredStatement<? extends CreateAsSelect> original, CreateSourceAsProperties injectedProps) {
        CreateAsSelect statement = original.getStatement();
        CreateAsSelect withProps = statement.copyWith(injectedProps);
        KsqlParser.PreparedStatement<CreateAsSelect> prepared = SourcePropertyInjector.buildPreparedStatement(withProps);
        return ConfiguredStatement.of(prepared, original.getSessionConfig());
    }

    private static <T extends Statement> KsqlParser.PreparedStatement<T> buildPreparedStatement(T stmt) {
        return KsqlParser.PreparedStatement.of((String)SqlFormatter.formatSql(stmt), stmt);
    }
}

