/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.scalablepush.ScalablePushRegistry;
import io.confluent.ksql.execution.streams.materialization.Materialization;
import io.confluent.ksql.execution.streams.materialization.MaterializationProvider;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.ProcessingLoggerFactory;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.query.KafkaStreamsBuilder;
import io.confluent.ksql.query.MaterializationProviderBuilderFactory;
import io.confluent.ksql.query.QueryErrorClassifier;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.schema.query.QuerySchemas;
import io.confluent.ksql.util.KafkaStreamsThreadError;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryMetadata;
import io.confluent.ksql.util.QueryMetadataImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.errors.StreamsUncaughtExceptionHandler;

public class PersistentQueryMetadataImpl
extends QueryMetadataImpl
implements PersistentQueryMetadata {
    private final KsqlConstants.PersistentQueryType persistentQueryType;
    private final Optional<DataSource> sinkDataSource;
    private final QuerySchemas schemas;
    private final PhysicalSchema resultSchema;
    private final ExecutionStep<?> physicalPlan;
    private final Optional<MaterializationProviderBuilderFactory.MaterializationProviderBuilder> materializationProviderBuilder;
    private final Optional<ScalablePushRegistry> scalablePushRegistry;
    private final ProcessingLogger processingLogger;
    private Optional<MaterializationProvider> materializationProvider;
    private final ScheduledExecutorService executorService;

    public PersistentQueryMetadataImpl(KsqlConstants.PersistentQueryType persistentQueryType, String statementString, PhysicalSchema schema, Set<SourceName> sourceNames, Optional<DataSource> sinkDataSource, String executionPlan, QueryId id, Optional<MaterializationProviderBuilderFactory.MaterializationProviderBuilder> materializationProviderBuilder, String queryApplicationId, Topology topology, KafkaStreamsBuilder kafkaStreamsBuilder, QuerySchemas schemas, Map<String, Object> streamsProperties, Map<String, Object> overriddenProperties, long closeTimeout, QueryErrorClassifier errorClassifier, ExecutionStep<?> physicalPlan, int maxQueryErrorsQueueSize, ProcessingLogger processingLogger, long retryBackoffInitialMs, long retryBackoffMaxMs, QueryMetadata.Listener listener, Optional<ScalablePushRegistry> scalablePushRegistry, ProcessingLoggerFactory loggerFactory) {
        super(statementString, schema.logicalSchema(), sourceNames, executionPlan, queryApplicationId, topology, kafkaStreamsBuilder, streamsProperties, overriddenProperties, closeTimeout, id, errorClassifier, maxQueryErrorsQueueSize, retryBackoffInitialMs, retryBackoffMaxMs, new PersistentQueryMetadata.QueryListenerWrapper(listener, scalablePushRegistry), loggerFactory);
        this.sinkDataSource = Objects.requireNonNull(sinkDataSource, "sinkDataSource");
        this.schemas = Objects.requireNonNull(schemas, "schemas");
        this.resultSchema = Objects.requireNonNull(schema, "schema");
        this.physicalPlan = Objects.requireNonNull(physicalPlan, "physicalPlan");
        this.materializationProviderBuilder = Objects.requireNonNull(materializationProviderBuilder, "materializationProviderBuilder");
        this.processingLogger = Objects.requireNonNull(processingLogger, "processingLogger");
        this.scalablePushRegistry = Objects.requireNonNull(scalablePushRegistry, "scalablePushRegistry");
        this.persistentQueryType = Objects.requireNonNull(persistentQueryType, "persistentQueryType");
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("ksql-csu-metrics-reporter-%d").build());
    }

    protected PersistentQueryMetadataImpl(PersistentQueryMetadataImpl original, QueryMetadata.Listener listener) {
        super(original, listener);
        this.sinkDataSource = original.getSink();
        this.schemas = original.schemas;
        this.resultSchema = original.resultSchema;
        this.materializationProvider = original.materializationProvider;
        this.physicalPlan = original.getPhysicalPlan();
        this.materializationProviderBuilder = original.materializationProviderBuilder;
        this.processingLogger = original.processingLogger;
        this.scalablePushRegistry = original.scalablePushRegistry;
        this.persistentQueryType = original.getPersistentQueryType();
        this.executorService = original.executorService;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setUncaughtExceptionHandler(this::uncaughtHandler);
        this.materializationProvider = this.materializationProviderBuilder.flatMap(builder -> (Optional)builder.apply(this.getKafkaStreams(), this.getTopology()));
    }

    @Override
    public StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse uncaughtHandler(Throwable error) {
        StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse response = super.uncaughtHandler(error);
        this.processingLogger.error((ProcessingLogger.ErrorMessage)KafkaStreamsThreadError.of("Unhandled exception caught in streams thread", Thread.currentThread(), error));
        return response;
    }

    @Override
    public Optional<DataSource.DataSourceType> getDataSourceType() {
        return this.sinkDataSource.map(DataSource::getDataSourceType);
    }

    @Override
    public Optional<KsqlTopic> getResultTopic() {
        return this.sinkDataSource.map(DataSource::getKsqlTopic);
    }

    @Override
    public Optional<SourceName> getSinkName() {
        return this.sinkDataSource.map(DataSource::getName);
    }

    @Override
    public QuerySchemas getQuerySchemas() {
        return this.schemas;
    }

    @Override
    public PhysicalSchema getPhysicalSchema() {
        return this.resultSchema;
    }

    @Override
    public ExecutionStep<?> getPhysicalPlan() {
        return this.physicalPlan;
    }

    @Override
    public Optional<DataSource> getSink() {
        return this.sinkDataSource;
    }

    @Override
    public KsqlConstants.PersistentQueryType getPersistentQueryType() {
        return this.persistentQueryType;
    }

    @Override
    @VisibleForTesting
    public ProcessingLogger getProcessingLogger() {
        return this.processingLogger;
    }

    @Override
    public Optional<Materialization> getMaterialization(QueryId queryId, QueryContext.Stacker contextStacker) {
        return this.materializationProvider.map(builder -> builder.build(queryId, contextStacker));
    }

    @Override
    public synchronized void stop() {
        this.doClose(false);
        this.scalablePushRegistry.ifPresent(ScalablePushRegistry::close);
    }

    @Override
    public void stop(boolean resetOffsets) {
        this.stop();
    }

    @Override
    public void register() {
    }

    @Override
    public Optional<ScalablePushRegistry> getScalablePushRegistry() {
        return this.scalablePushRegistry;
    }

    @Override
    public Collection<String> getSourceTopicNames() {
        return Collections.emptySet();
    }
}

