/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.List;

public final class Repartitioning {
    private Repartitioning() {
    }

    public static boolean repartitionNeeded(LogicalSchema schema, List<Expression> partitionBy) {
        if (schema.key().isEmpty()) {
            return true;
        }
        if (schema.key().size() != 1) {
            return true;
        }
        if (partitionBy.size() != schema.key().size()) {
            return true;
        }
        Expression expression = partitionBy.get(0);
        if (!(expression instanceof ColumnReferenceExp)) {
            return true;
        }
        ColumnName newKeyColName = ((ColumnReferenceExp)expression).getColumnName();
        return !newKeyColName.equals((Object)((Column)schema.key().get(0)).name());
    }
}

