/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.logging.processing.ProcessingLoggerFactory;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.query.BlockingRowQueue;
import io.confluent.ksql.query.CompletionHandler;
import io.confluent.ksql.query.KafkaStreamsBuilder;
import io.confluent.ksql.query.LimitHandler;
import io.confluent.ksql.query.QueryErrorClassifier;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.PushQueryMetadata;
import io.confluent.ksql.util.QueryMetadata;
import io.confluent.ksql.util.QueryMetadataImpl;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.streams.Topology;

public class TransientQueryMetadata
extends QueryMetadataImpl
implements PushQueryMetadata {
    private final BlockingRowQueue rowQueue;
    private final PushQueryMetadata.ResultType resultType;
    final AtomicBoolean isRunning = new AtomicBoolean(true);

    public TransientQueryMetadata(String statementString, LogicalSchema logicalSchema, Set<SourceName> sourceNames, String executionPlan, BlockingRowQueue rowQueue, QueryId queryId, String queryApplicationId, Topology topology, KafkaStreamsBuilder kafkaStreamsBuilder, Map<String, Object> streamsProperties, Map<String, Object> overriddenProperties, long closeTimeout, int maxQueryErrorsQueueSize, PushQueryMetadata.ResultType resultType, long retryBackoffInitialMs, long retryBackoffMaxMs, QueryMetadata.Listener listener, ProcessingLoggerFactory loggerFactory) {
        super(statementString, logicalSchema, sourceNames, executionPlan, queryApplicationId, topology, kafkaStreamsBuilder, streamsProperties, overriddenProperties, closeTimeout, queryId, QueryErrorClassifier.DEFAULT_CLASSIFIER, maxQueryErrorsQueueSize, retryBackoffInitialMs, retryBackoffMaxMs, listener, loggerFactory);
        this.rowQueue = Objects.requireNonNull(rowQueue, "rowQueue");
        this.resultType = Objects.requireNonNull(resultType, "resultType");
    }

    public TransientQueryMetadata(TransientQueryMetadata original, BlockingRowQueue rowQueue, QueryMetadata.Listener listener) {
        super(original, listener);
        this.rowQueue = Objects.requireNonNull(rowQueue, "rowQueue");
        this.resultType = original.resultType;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning.get() && this.getKafkaStreams().state().isRunningOrRebalancing();
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public BlockingRowQueue getRowQueue() {
        return this.rowQueue;
    }

    @Override
    public KsqlConstants.KsqlQueryType getQueryType() {
        return KsqlConstants.KsqlQueryType.PUSH;
    }

    @Override
    public PushQueryMetadata.ResultType getResultType() {
        return this.resultType;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TransientQueryMetadata)) {
            return false;
        }
        TransientQueryMetadata that = (TransientQueryMetadata)o;
        return Objects.equals(this.rowQueue, that.rowQueue) && Objects.equals((Object)this.resultType, (Object)that.resultType) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rowQueue, this.resultType, super.hashCode()});
    }

    @Override
    public void setLimitHandler(LimitHandler limitHandler) {
        this.rowQueue.setLimitHandler(limitHandler);
    }

    @Override
    public void setCompletionHandler(CompletionHandler completionHandler) {
        this.rowQueue.setCompletionHandler(completionHandler);
    }

    @Override
    public void close() {
        if (!this.isRunning.compareAndSet(true, false)) {
            return;
        }
        this.rowQueue.close();
        super.close();
    }
}

