/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util.json;

import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.AbstractIterator;
import io.confluent.ksql.util.KsqlException;
import java.util.Objects;

public class JsonPathTokenizer
extends AbstractIterator<String> {
    private static final char QUOTE = '\"';
    private static final char BACKSLASH = '\\';
    private static final char DOT = '.';
    private static final char OPEN_BRACKET = '[';
    private static final char CLOSE_BRACKET = ']';
    private static final char UNICODE_CARET = '\u2038';
    private final String path;
    private int index;

    public JsonPathTokenizer(String path) {
        this.path = Objects.requireNonNull(path, "path is null");
        if (path.isEmpty()) {
            throw this.invalidJsonPath();
        }
        this.match('$');
    }

    protected String computeNext() {
        if (!this.hasNextCharacter()) {
            return (String)this.endOfData();
        }
        if (this.tryMatch('.')) {
            return this.matchPathSegment();
        }
        if (this.tryMatch('[')) {
            String token = this.tryMatch('\"') ? this.matchQuotedSubscript() : this.matchUnquotedSubscript();
            this.match(']');
            return token;
        }
        throw this.invalidJsonPath();
    }

    private String matchPathSegment() {
        int start = this.index;
        while (this.hasNextCharacter() && JsonPathTokenizer.isUnquotedPathCharacter(this.peekCharacter())) {
            this.nextCharacter();
        }
        int end = this.index;
        String token = this.path.substring(start, end);
        if (token.isEmpty()) {
            throw this.invalidJsonPath();
        }
        return token;
    }

    private static boolean isUnquotedPathCharacter(char c) {
        return c == ':' || c == '@' || JsonPathTokenizer.isUnquotedSubscriptCharacter(c);
    }

    private String matchUnquotedSubscript() {
        int start = this.index;
        while (this.hasNextCharacter() && JsonPathTokenizer.isUnquotedSubscriptCharacter(this.peekCharacter())) {
            this.nextCharacter();
        }
        int end = this.index;
        String token = this.path.substring(start, end);
        if (token.isEmpty()) {
            throw this.invalidJsonPath();
        }
        return token;
    }

    private static boolean isUnquotedSubscriptCharacter(char c) {
        return c == '_' || Character.isLetterOrDigit(c);
    }

    private String matchQuotedSubscript() {
        StringBuilder token = new StringBuilder();
        boolean escaped = false;
        while (this.hasNextCharacter() && (escaped || this.peekCharacter() != '\"')) {
            if (escaped) {
                switch (this.peekCharacter()) {
                    case '\"': 
                    case '\\': {
                        token.append(this.peekCharacter());
                        break;
                    }
                    default: {
                        throw this.invalidJsonPath();
                    }
                }
                escaped = false;
            } else {
                switch (this.peekCharacter()) {
                    case '\\': {
                        escaped = true;
                        break;
                    }
                    case '\"': {
                        throw new VerifyException("Should be handled by loop condition");
                    }
                    default: {
                        token.append(this.peekCharacter());
                    }
                }
            }
            this.nextCharacter();
        }
        if (escaped) {
            Verify.verify((!this.hasNextCharacter() ? 1 : 0) != 0, (String)"Loop terminated after escape while there is still input", (Object[])new Object[0]);
            throw this.invalidJsonPath();
        }
        this.match('\"');
        return token.toString();
    }

    private boolean hasNextCharacter() {
        return this.index < this.path.length();
    }

    private void match(char expected) {
        if (!this.tryMatch(expected)) {
            throw this.invalidJsonPath();
        }
    }

    private boolean tryMatch(char expected) {
        if (!this.hasNextCharacter() || this.peekCharacter() != expected) {
            return false;
        }
        ++this.index;
        return true;
    }

    private void nextCharacter() {
        ++this.index;
    }

    private char peekCharacter() {
        return this.path.charAt(this.index);
    }

    private KsqlException invalidJsonPath() {
        return new KsqlException(String.format("Invalid JSON path: '%s'", this.path));
    }

    public String toString() {
        return this.path.substring(0, this.index) + '\u2038' + this.path.substring(this.index);
    }
}

