/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import io.confluent.auditlogapi.entities.AuditLogConfigDestinationConfig;
import io.confluent.auditlogapi.entities.AutoValue_AuditLogConfigDestinations;
import io.confluent.auditlogapi.entities.Validations;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"bootstrap_servers", "topics"})
@JsonSerialize(as=AuditLogConfigDestinations.class)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AuditLogConfigDestinations {
    @JsonProperty(value="bootstrap_servers")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract ImmutableList<String> getBootstrapServers();

    @JsonProperty(value="topics")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract ImmutableSortedMap<String, AuditLogConfigDestinationConfig> getTopics();

    @Nonnull
    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_AuditLogConfigDestinations.Builder();
        }

        @JsonProperty(value="bootstrap_servers")
        public abstract Builder bootstrapServers(Collection<String> var1);

        abstract ImmutableList.Builder<String> bootstrapServersBuilder();

        public Builder bootstrapServer(String bootstrapServer) {
            this.bootstrapServersBuilder().add((Object)bootstrapServer);
            return this;
        }

        @JsonProperty(value="topics")
        public abstract Builder topics(Map<String, AuditLogConfigDestinationConfig> var1);

        abstract ImmutableSortedMap.Builder<String, AuditLogConfigDestinationConfig> topicsBuilder();

        public Builder topic(String topicName, AuditLogConfigDestinationConfig destinationConfig) {
            this.topicsBuilder().put((Object)topicName, (Object)destinationConfig);
            return this;
        }

        abstract AuditLogConfigDestinations autoBuild();

        public AuditLogConfigDestinations build() {
            AuditLogConfigDestinations built = this.autoBuild();
            if (built.getBootstrapServers() != null) {
                built.getBootstrapServers().forEach(hostAndPort -> Validations.requireValidHostAndPort(hostAndPort, "bootstrap_servers"));
            }
            built.getTopics().forEach((topicName, destinationConfig) -> Validations.requireValidAuditLogTopicName(topicName, "topics"));
            return built;
        }
    }
}

