/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.auto.value.AutoValue;
import io.confluent.auditlogapi.entities.AutoValue_AuditLogConfigRouteCategoryTopics;
import io.confluent.auditlogapi.entities.Validations;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"allowed", "denied"})
@JsonSerialize(as=AuditLogConfigRouteCategoryTopics.class)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AuditLogConfigRouteCategoryTopics {
    @Nullable
    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public abstract String getAllowed();

    @Nullable
    @JsonProperty(value="denied")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public abstract String getDenied();

    @Nonnull
    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_AuditLogConfigRouteCategoryTopics.Builder();
        }

        @Nonnull
        @JsonProperty(value="allowed")
        public abstract Builder allowed(@Nullable String var1);

        @Nonnull
        @JsonProperty(value="denied")
        public abstract Builder denied(@Nullable String var1);

        abstract AuditLogConfigRouteCategoryTopics autoBuild();

        public AuditLogConfigRouteCategoryTopics build() {
            AuditLogConfigRouteCategoryTopics built = this.autoBuild();
            if (built.getAllowed() != null) {
                Validations.requireValidAuditLogTopicName(built.getAllowed(), "allowed");
            }
            if (built.getDenied() != null) {
                Validations.requireValidAuditLogTopicName(built.getDenied(), "denied");
            }
            return built;
        }
    }
}

