/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlogapi.store;

import io.confluent.auditlogapi.credentials.ExtractedCredentials;
import io.confluent.auditlogapi.entities.AuditLogConfigSpec;
import io.confluent.auditlogapi.store.BaseAuditLogConfigStore;
import io.confluent.auditlogapi.store.ConcurrentModificationRetriableException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;

public class StubAuditLogConfigStore
extends BaseAuditLogConfigStore {
    private final AtomicReference<AuditLogConfigSpec> specRef = new AtomicReference<AuditLogConfigSpec>(DEFAULT_SPEC);

    @Override
    protected final AuditLogConfigSpec get() {
        return this.specRef.get();
    }

    @Override
    protected CompletionStage<AuditLogConfigSpec> asyncCompareAndSet(AuditLogConfigSpec configuredSpec, AuditLogConfigSpec newSpec) {
        if (this.specRef.compareAndSet(configuredSpec, newSpec)) {
            return CompletableFuture.completedFuture(newSpec);
        }
        CompletableFuture<AuditLogConfigSpec> retriableFailure = new CompletableFuture<AuditLogConfigSpec>();
        retriableFailure.completeExceptionally((Throwable)((Object)new ConcurrentModificationRetriableException()));
        return retriableFailure;
    }

    @Override
    protected CompletionStage<AuditLogConfigSpec> asyncBroadcast(ExtractedCredentials extractedCredentials, AuditLogConfigSpec spec) {
        return CompletableFuture.completedFuture(spec);
    }

    @Override
    public void close() throws IOException {
    }
}

