/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.metadataapi.app;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.metadataapi.errormappers.MetadataApiExceptionMapper;
import io.confluent.metadataapi.resources.MetadataResource;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.validation.JacksonMessageBodyProvider;
import javax.ws.rs.core.Configurable;
import org.apache.kafka.server.license.LicenseTrackingInfoHolder;

public final class MetadataApiApplication
extends Application<RestConfig> {
    private final String clusterId;
    private final String schemaRegistryUrls;
    private final LicenseTrackingInfoHolder licenseTrackingInfoHolder;

    public MetadataApiApplication(String clusterId, String schemaRegistryUrls, LicenseTrackingInfoHolder licenseTrackingInfoHolder) {
        super(new RestConfig(RestConfig.baseConfigDef()), "/v1/metadata");
        this.clusterId = clusterId;
        this.schemaRegistryUrls = schemaRegistryUrls;
        this.licenseTrackingInfoHolder = licenseTrackingInfoHolder;
    }

    public void setupResources(Configurable<?> context, RestConfig appConfig) {
        ObjectMapper jsonMapper = new ObjectMapper();
        JacksonMessageBodyProvider jsonProvider = new JacksonMessageBodyProvider(jsonMapper);
        context.register((Object)jsonProvider);
        context.register((Object)new MetadataApiExceptionMapper());
        context.register((Object)new MetadataResource(this.clusterId, this.schemaRegistryUrls, this.licenseTrackingInfoHolder));
    }

    public void onShutdown() {
    }
}

