/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.v1;

import io.confluent.auditlogapi.authorizer.AuditLogConfigAuthorizer;
import io.confluent.auditlogapi.credentials.CredentialExtractor;
import io.confluent.auditlogapi.entities.AuditLogConfigListRoutesResponse;
import io.confluent.auditlogapi.entities.AuditLogConfigResolveResourceRouteResponse;
import io.confluent.auditlogapi.entities.AuditLogConfigSpec;
import io.confluent.auditlogapi.store.AuditLogConfigStore;
import io.confluent.auditlogapi.store.TopicRetentionLookup;
import io.confluent.auditlogapi.store.TopicRetentionUpdateCallback;
import io.confluent.rbacapi.resources.base.AuditLogConfigResource;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/1.0/audit")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class V1AuditLogConfigResource {
    private final AuditLogConfigResource delegate;

    public V1AuditLogConfigResource(AuditLogConfigAuthorizer authorizer, AuditLogConfigStore store, CredentialExtractor credentialExtractor, TopicRetentionLookup currentRetentionLookup, TopicRetentionUpdateCallback retentionUpdateCallback, long backendTimeoutNanos) {
        this.delegate = new AuditLogConfigResource(authorizer, store, credentialExtractor, currentRetentionLookup, retentionUpdateCallback, backendTimeoutNanos);
    }

    @GET
    @Path(value="config")
    @PerformanceMetric(value="v1.auditlog.config.get")
    public AuditLogConfigSpec getConfig(@Context SecurityContext context) {
        return this.delegate.getConfig(context);
    }

    @PUT
    @Path(value="config")
    @PerformanceMetric(value="v1.auditlog.config.put")
    public Response putConfig(@Context HttpServletRequest request, @Context SecurityContext context, AuditLogConfigSpec putSpec) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.putConfig(request, context, putSpec);
    }

    @GET
    @Path(value="routes")
    @PerformanceMetric(value="v1.auditlog.list.routes")
    public AuditLogConfigListRoutesResponse listRoutes(@Context SecurityContext context, @QueryParam(value="q") String query) {
        return this.delegate.listRoutes(context, query);
    }

    @GET
    @Path(value="lookup")
    @PerformanceMetric(value="v1.auditlog.resource.route")
    public AuditLogConfigResolveResourceRouteResponse resolveResourceRoute(@Context SecurityContext context, @QueryParam(value="crn") String query) {
        return this.delegate.resolveResourceRoute(context, query);
    }
}

