/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.v1;

import io.confluent.oidc.entities.CheckDeviceAuthRequest;
import io.confluent.oidc.entities.CheckDeviceAuthResponse;
import io.confluent.oidc.entities.ExtendAuthResponse;
import io.confluent.oidc.entities.InitDeviceAuthResponse;
import io.confluent.oidc.resources.OidcDeviceAuthResource;
import io.confluent.oidc.services.OidcTokenService;
import io.confluent.rest.annotations.PerformanceMetric;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Path(value="/1.0/oidc/device")
@Produces(value={"application/json"})
public class V1OidcDeviceAuthResource {
    private final OidcDeviceAuthResource delegate;

    public V1OidcDeviceAuthResource(OidcTokenService oidcTokenService) {
        this.delegate = new OidcDeviceAuthResource(oidcTokenService);
    }

    @POST
    @Path(value="/authenticate")
    @PerformanceMetric(value="v1.oidc.device.authenticate")
    public InitDeviceAuthResponse createDeviceAuthInfo() {
        return this.delegate.createDeviceAuthInfo();
    }

    @POST
    @Path(value="/check-auth")
    @PerformanceMetric(value="v1.oidc.device.check-auth")
    public CheckDeviceAuthResponse checkAuth(CheckDeviceAuthRequest request) {
        return this.delegate.checkUserAuthAction(request);
    }

    @GET
    @Path(value="/extend-auth")
    @PerformanceMetric(value="v1.oidc.device.extend-auth")
    public ExtendAuthResponse extendAuth(@Context SecurityContext securityContext) {
        return this.delegate.extendAuth(securityContext);
    }
}

