/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.v1;

import io.confluent.rbacapi.authorizer.SecurityMetadataAuthorizer;
import io.confluent.rbacapi.entities.MdsScope;
import io.confluent.rbacapi.resources.base.OperationsResource;
import io.confluent.rbacapi.services.ClusterRegistryService;
import io.confluent.rbacapi.services.RoleBindingProcessing;
import io.confluent.rbacapi.validation.base.ValidationUtil;
import io.confluent.rbacapi.validation.common.ValidOperation;
import io.confluent.rbacapi.validation.common.ValidPrincipal;
import io.confluent.rbacapi.validation.common.ValidResourceType;
import io.confluent.rbacapi.validation.v1.V1ValidMdsScope;
import io.confluent.rbacapi.validation.v1.V1ValidationUtil;
import io.confluent.rest.annotations.PerformanceMetric;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Path(value="/1.0/lookup")
@Produces(value={"application/json"})
public class V1OperationsResource {
    private final OperationsResource delegate;

    public V1OperationsResource(RoleBindingProcessing roleBindingProcessing, SecurityMetadataAuthorizer metadataAuthorizer, ClusterRegistryService clusterRegistryService) {
        this.delegate = new OperationsResource(roleBindingProcessing, metadataAuthorizer, clusterRegistryService, (ValidationUtil)new V1ValidationUtil());
    }

    @POST
    @Path(value="principal/{principal}/resource/{resourceType}/operation/{operation:Create|AlterAccess}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v1.lookup.principals.with.role.on.resource")
    public RoleBindingProcessing.OperationGuidelines lookupPrincipalsWithRoleOnResource(@Context SecurityContext context, @PathParam(value="resourceType") @ValidResourceType String resourceType, @PathParam(value="principal") @ValidPrincipal String principal, @PathParam(value="operation") @ValidOperation String operation, @V1ValidMdsScope MdsScope mdsScope) {
        return this.delegate.lookupPrincipalsWithRoleOnResource(context, resourceType, principal, operation, mdsScope);
    }
}

