/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.services;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.rbacapi.entities.ManagedRoleBindings;
import io.confluent.rbacapi.services.ClusterPermissions;
import io.confluent.rbacapi.services.ClusterPermissionsBuilder;
import io.confluent.rbacapi.utils.RoleAccessUtils;
import io.confluent.rbacapi.utils.RoleUtils;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.Role;
import io.confluent.security.rbac.RoleBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class ManagedRoleBindingsBuilder {
    private final AuthCache authCache;
    private final ClusterPermissionsBuilder clusterPermissionsBuilder;

    public ManagedRoleBindingsBuilder(AuthCache authCache) {
        this(authCache, new ClusterPermissionsBuilder());
    }

    @VisibleForTesting
    ManagedRoleBindingsBuilder(AuthCache authCache, ClusterPermissionsBuilder clusterPermissionsBuilder) {
        this.authCache = authCache;
        this.clusterPermissionsBuilder = clusterPermissionsBuilder;
    }

    public ManagedRoleBindings build(Scope scope, KafkaPrincipal principal, ResourceType resourceType) {
        ManagedRoleBindings managedRoleBindings = new ManagedRoleBindings(scope);
        Map allRolesByName = RoleUtils.mapRolesByName((Collection)this.authCache.rbacRoles().roles());
        Set<Scope> scopes = this.scopeHierarchy(scope);
        Set roleBindings = this.authCache.rbacRoleBindings(scopes);
        if (roleBindings == null || roleBindings.isEmpty()) {
            return managedRoleBindings;
        }
        ScopedClusterPermissions clusterPermissions = new ScopedClusterPermissions(scopes, principal, resourceType, allRolesByName, roleBindings);
        for (RoleBinding roleBinding : roleBindings) {
            Role role = (Role)allRolesByName.get(roleBinding.role());
            if (role == null) continue;
            if (role.bindWithResource()) {
                roleBinding.resources().stream().filter(ManagedRoleBindingsBuilder.byResourceType(resourceType)).filter(resourcePattern -> clusterPermissions.canDescribeAccess((ResourcePattern)resourcePattern)).map(resourcePattern -> new ManagedRoleBindings.ManagedResourceBinding(role.displayName(), resourcePattern, clusterPermissions.canAlterAccess((ResourcePattern)resourcePattern))).forEach(managedResourceBinding -> managedRoleBindings.add(roleBinding.principal(), managedResourceBinding));
                continue;
            }
            if (!clusterPermissions.isClusterRoleDescribeAccess()) continue;
            managedRoleBindings.add(roleBinding.principal(), new ManagedRoleBindings.ManagedClusterBinding(role.displayName(), clusterPermissions.isClusterRoleAlterAccess()));
        }
        return managedRoleBindings;
    }

    private static Predicate<ResourcePattern> byResourceType(ResourceType resourceType) {
        return resourcePattern -> resourceType.equals((Object)ResourceType.ALL) || resourcePattern.resourceType().equals((Object)resourceType);
    }

    private Set<KafkaPrincipal> getPrincipalAndGroups(KafkaPrincipal principal) {
        HashSet<KafkaPrincipal> targetPrincipals = new HashSet<KafkaPrincipal>();
        targetPrincipals.add(new KafkaPrincipal(principal.getPrincipalType(), principal.getName()));
        if (StringUtils.equals((CharSequence)"User", (CharSequence)principal.getPrincipalType())) {
            targetPrincipals.addAll(this.authCache.groups(principal));
        }
        return targetPrincipals;
    }

    private boolean hasParentScope(Scope scope) {
        return scope.parent() != null && !scope.parent().equals((Object)Scope.ROOT_SCOPE);
    }

    private Set<Scope> scopeHierarchy(Scope scope) {
        HashSet<Scope> scopes = new HashSet<Scope>();
        scopes.add(scope);
        while (this.hasParentScope(scope)) {
            scope = scope.parent();
            scopes.add(scope);
        }
        return scopes;
    }

    private class ScopedClusterPermissions {
        private boolean clusterRoleDescribeAccess;
        private boolean clusterRoleAlterAccess;
        private List<ClusterPermissions> clusterPermissionsHierarchy = new ArrayList<ClusterPermissions>();

        private ScopedClusterPermissions(Set<Scope> scopes, KafkaPrincipal principal, ResourceType resourceType, Map<String, Role> allRolesByName, Set<RoleBinding> roleBindings) {
            Map roleBindingsByScope = roleBindings.stream().collect(Collectors.groupingBy(RoleBinding::scope, Collectors.mapping(Function.identity(), Collectors.toSet())));
            Map accessRolesByName = RoleUtils.mapRolesByName(allRolesByName.values(), (Predicate)RoleAccessUtils.filterByDescribeAccess());
            scopes.forEach(scope -> {
                if (roleBindingsByScope.get(scope) == null || ((Set)roleBindingsByScope.get(scope)).isEmpty()) {
                    return;
                }
                Set principalAndGroups = ManagedRoleBindingsBuilder.this.getPrincipalAndGroups(principal);
                ClusterPermissions clusterPermissions = ManagedRoleBindingsBuilder.this.clusterPermissionsBuilder.build(accessRolesByName, principalAndGroups, (Scope)scope, resourceType, (Collection)roleBindingsByScope.get(scope));
                this.clusterPermissionsHierarchy.add(clusterPermissions);
                this.clusterRoleDescribeAccess = this.clusterRoleDescribeAccess || clusterPermissions.canDescribeAccess(ResourceType.ALL);
                this.clusterRoleAlterAccess = this.clusterRoleAlterAccess || clusterPermissions.canAlterAccess(ResourceType.ALL);
            });
        }

        public boolean isClusterRoleDescribeAccess() {
            return this.clusterRoleDescribeAccess;
        }

        public boolean isClusterRoleAlterAccess() {
            return this.clusterRoleAlterAccess;
        }

        public boolean canDescribeAccess(ResourcePattern resourcePattern) {
            return this.clusterPermissionsHierarchy.stream().anyMatch(c -> c.canDescribeAccess(resourcePattern));
        }

        public boolean canAlterAccess(ResourcePattern resourcePattern) {
            return this.clusterPermissionsHierarchy.stream().anyMatch(c -> c.canAlterAccess(resourcePattern));
        }
    }
}

