/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.printmetrics;

import io.confluent.ksql.tools.printmetrics.ArgumentParseException;
import io.confluent.ksql.tools.printmetrics.PrintMetricsException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public final class PrintMetrics {
    private PrintMetrics() {
    }

    public static void printHelp() {
        System.err.println("usage: PrintMetrics [help] port=<KSQL JMX Port>\n\nThis utility prints the following operational metrics tracked by ksql:\n\nmessages-consumed-per-sec: Messages consumed per second across all queries\nmessages-consumed-avg:     The average number of messages consumed by a query per second\nmessages-consumed-min:     Messages consumed per second for the query with the fewest messages consumed per second\nmessages-consumed-max:     Messages consumed per second for the query with the most messages consumed per second\nmessages-produced-per-sec: Messages produced per second across all queries\nerror-rate:                The number of messages which were consumed but not  processed across all queries\nnum-persistent-queries:    The number of queries currently executing.\nnum-active-queries:        The number of queries actively processing messages.\nnum-idle-queries:          The number of queries with no messages available to process.\n");
        System.err.println("To use this tool, when running ksql-server-start you must set the JMX_PORT environmnent variable to an open port for the JMX service to listen on.");
    }

    private static void printMetrics(int port) throws IOException {
        JMXServiceURL jmxUrl = new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://localhost:%d/jmxrmi", port));
        JMXConnector connector = JMXConnectorFactory.connect(jmxUrl);
        connector.connect();
        MBeanServerConnection connection = connector.getMBeanServerConnection();
        Set<ObjectName> names = connection.queryNames(null, null);
        LinkedList<ObjectName> ksqlObjects = new LinkedList<ObjectName>();
        for (ObjectName n : names) {
            if (!n.toString().startsWith("io.confluent.ksql.metrics:type=ksql-engine")) continue;
            ksqlObjects.add(n);
        }
        for (ObjectName n : ksqlObjects) {
            MBeanAttributeInfo[] attributes;
            MBeanInfo info;
            try {
                info = connection.getMBeanInfo(n);
            }
            catch (Exception error) {
                throw new PrintMetricsException("Unexpected error getting mbean info " + error.getMessage());
            }
            for (MBeanAttributeInfo attributeInfo : attributes = info.getAttributes()) {
                Object attribute;
                try {
                    attribute = connection.getAttribute(n, attributeInfo.getName());
                }
                catch (Exception error) {
                    throw new PrintMetricsException("Unexpected error getting attribute " + error.getMessage());
                }
                System.out.println(attributeInfo.getName() + ": " + attribute);
            }
        }
    }

    public static void main(String[] progArgs) throws IOException {
        Arguments args = Arguments.parse(progArgs);
        if (args.help) {
            PrintMetrics.printHelp();
            return;
        }
        PrintMetrics.printMetrics(args.port);
    }

    private static final class Arguments {
        private final boolean help;
        private final int port;

        private Arguments(boolean help, int port) {
            this.help = help;
            this.port = port;
        }

        private static Arguments parse(String[] args) {
            boolean help = false;
            int port = -1;
            block6: for (String arg : args) {
                if ("help".equals(arg)) {
                    help = true;
                    continue;
                }
                String[] splitOnEquals = arg.split("=");
                if (splitOnEquals.length != 2) {
                    throw new ArgumentParseException(String.format("Invalid argument format in '%s'; expected <name>=<value>", arg));
                }
                String argName = splitOnEquals[0].trim();
                String argValue = splitOnEquals[1].trim();
                if (argName.isEmpty()) {
                    throw new ArgumentParseException(String.format("Empty argument name in %s", arg));
                }
                if (argValue.isEmpty()) {
                    throw new ArgumentParseException(String.format("Empty argument value in '%s'", arg));
                }
                switch (argName) {
                    case "port": {
                        port = Integer.decode(argValue);
                        continue block6;
                    }
                    default: {
                        throw new ArgumentParseException(String.format("Invalid argument value '%s'", argName));
                    }
                }
            }
            return new Arguments(help, port);
        }
    }
}

