/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.metrics.reporter;

import io.confluent.shaded.io.confluent.metrics.record.ConfluentMetric;
import io.confluent.shaded.io.confluent.serializers.ProtoSerde;
import java.io.PrintStream;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;

public class ConfluentMetricsFormatter
implements MessageFormatter {
    private final ProtoSerde<ConfluentMetric.MetricsMessage> serdes = new ProtoSerde<ConfluentMetric.MetricsMessage>(ConfluentMetric.MetricsMessage.getDefaultInstance());
    private boolean printTopic;
    private boolean printPartition;
    private boolean printTs;
    private boolean printKey;
    private String fieldSeparator;
    private String lineSeparator;

    public void configure(Map<String, ?> configs) {
        this.printTopic = this.getBoolean(configs, "print.topic", false);
        this.printPartition = this.getBoolean(configs, "print.partition", false);
        this.printTs = this.getBoolean(configs, "print.timestamp", false);
        this.printKey = this.getBoolean(configs, "print.key", false);
        this.lineSeparator = this.getString(configs, "line.separator", "\n");
        this.fieldSeparator = this.getString(configs, "field.separator", "\t");
    }

    private boolean getBoolean(Map<String, ?> configs, String name, boolean defaultValue) {
        if (configs.containsKey(name)) {
            return Boolean.parseBoolean(this.getString(configs, name).trim());
        }
        return defaultValue;
    }

    private String getString(Map<String, ?> configs, String name) {
        return this.getString(configs, name, null);
    }

    private String getString(Map<String, ?> configs, String name, String defaultValue) {
        Object o = configs.get(name);
        if (o instanceof String) {
            return (String)o;
        }
        if (o == null) {
            return defaultValue;
        }
        throw new IllegalArgumentException("Unexpected type for config value for '" + name + "', expected String but found " + o.getClass() + ", value: " + o);
    }

    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        if (this.printTopic) {
            output.append(consumerRecord.topic());
            output.append(this.fieldSeparator);
        }
        if (this.printPartition) {
            output.append(Integer.toString(consumerRecord.partition()));
            output.append(this.fieldSeparator);
        }
        if (this.printTs) {
            output.append(Long.toString(consumerRecord.timestamp()));
            output.append(this.fieldSeparator);
        }
        if (this.printKey) {
            output.append("null");
            output.append(this.fieldSeparator);
        }
        output.append(this.getValueString(consumerRecord.topic(), (byte[])consumerRecord.value(), this.serdes));
        output.append(this.lineSeparator);
    }

    private String getValueString(String topic, byte[] valueBytes, ProtoSerde<ConfluentMetric.MetricsMessage> serdes) {
        String valueStr = "null";
        if (valueBytes != null) {
            ConfluentMetric.MetricsMessage value = (ConfluentMetric.MetricsMessage)serdes.deserialize(valueBytes);
            valueStr = serdes.toJson(value);
        }
        return valueStr;
    }

    public void close() {
    }
}

