/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.metrics.reporter;

import com.yammer.metrics.core.MetricsRegistry;
import io.confluent.metrics.reporter.ConfluentMetricsReporterConfig;
import io.confluent.metrics.reporter.KafkaMetricsHelper;
import io.confluent.metrics.reporter.VolumeMetricsProvider;
import io.confluent.metrics.reporter.YammerMetricsHelper;
import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.shaded.com.google.common.base.Function;
import io.confluent.shaded.com.google.common.collect.FluentIterable;
import io.confluent.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.confluent.shaded.io.confluent.metrics.YammerMetricsUtils;
import io.confluent.shaded.io.confluent.metrics.record.ConfluentMetric;
import io.confluent.shaded.io.confluent.serializers.ProtoSerde;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentMetricsReporter
implements MetricsReporter,
ClusterResourceListener {
    private static final Logger log = LoggerFactory.getLogger(ConfluentMetricsReporter.class);
    private static final MetricsRegistry METRICS_REGISTRY = KafkaYammerMetrics.defaultRegistry();
    private final ProtoSerde<ConfluentMetric.MetricsMessage> metricsMessageSerde = new ProtoSerde<ConfluentMetric.MetricsMessage>(ConfluentMetric.MetricsMessage.getDefaultInstance());
    private final Map<MetricName, KafkaMetric> metricMap = new ConcurrentHashMap<MetricName, KafkaMetric>();
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private final YammerMetricsHelper metricsHelper = new YammerMetricsHelper();
    private ConfluentMetricsReporterConfig metricsReporterConfig;
    private Properties clientProperties;
    private KafkaProducer<byte[], byte[]> producer;
    private long reportIntervalMs;
    private String publishTopic;
    private boolean createTopic;
    Pattern pattern = null;
    private volatile String clusterId = null;
    private volatile boolean started;
    private int brokerId;
    private String clientId;
    private String groupId;
    private ConfluentMetric.MetricType metricType;
    private long volumeMetricsRefreshPeriodMs = 15000L;
    private String[] volumeMetricsLogDirs = new String[0];
    private com.sun.management.OperatingSystemMXBean osBean;
    private String[] processRoles;

    public void contextChange(MetricsContext metricsContext) {
        Map contextLabels = metricsContext.contextLabels();
        String contextRoles = (String)contextLabels.get("kafka.process.roles");
        this.processRoles = contextRoles != null ? contextRoles.split(",") : new String[0];
    }

    public void onUpdate(ClusterResource clusterResource) {
        String newClusterId = clusterResource.clusterId();
        if (this.started) {
            if (newClusterId == null) {
                if (this.clusterId != null) {
                    log.debug("Confluent metrics reporter received null cluster id, continuing to use old cluster id {}", (Object)this.clusterId);
                }
            } else if (!newClusterId.equals(this.clusterId)) {
                log.info("Updating cluster id of Confluent metrics reporter from {} to {}", (Object)this.clusterId, (Object)newClusterId);
                this.clusterId = newClusterId;
            }
            return;
        }
        this.clusterId = newClusterId;
        log.info("Starting Confluent metrics reporter for cluster id {} with an interval of {} ms", (Object)this.clusterId, (Object)this.reportIntervalMs);
        this.executor.scheduleAtFixedRate(this.metricReportRunnable(), this.reportIntervalMs, this.reportIntervalMs, TimeUnit.MILLISECONDS);
        this.started = true;
    }

    public void configure(Map<String, ?> configs) {
        this.metricsReporterConfig = new ConfluentMetricsReporterConfig(configs);
        this.clientProperties = ConfluentMetricsReporterConfig.getClientProperties(configs);
        this.producer = new KafkaProducer(ConfluentMetricsReporterConfig.getProducerProperties(configs));
        this.reportIntervalMs = this.metricsReporterConfig.getLong("confluent.metrics.reporter.publish.ms");
        this.publishTopic = this.metricsReporterConfig.getString("confluent.metrics.reporter.topic");
        this.createTopic = this.metricsReporterConfig.getBoolean("confluent.metrics.reporter.topic.create");
        String regexString = this.metricsReporterConfig.getString("confluent.metrics.reporter.include").trim();
        Pattern pattern = this.pattern = regexString.isEmpty() ? null : Pattern.compile(regexString);
        this.metricType = configs.containsKey(KafkaConfig.BrokerIdProp()) ? ConfluentMetric.MetricType.BROKER : (configs.containsKey("key.deserializer") ? ConfluentMetric.MetricType.CONSUMER : (configs.containsKey("key.serializer") ? ConfluentMetric.MetricType.PRODUCER : ConfluentMetric.MetricType.UNKNOWN));
        this.brokerId = this.metricType == ConfluentMetric.MetricType.BROKER ? Integer.parseInt((String)configs.get(KafkaConfig.BrokerIdProp())) : -1;
        boolean isClient = this.metricType == ConfluentMetric.MetricType.CONSUMER || this.metricType == ConfluentMetric.MetricType.PRODUCER;
        this.clientId = isClient && configs.containsKey("client.id") ? (String)configs.get("client.id") : "";
        String string = this.groupId = this.metricType == ConfluentMetric.MetricType.CONSUMER && configs.containsKey("group.id") ? (String)configs.get("group.id") : "";
        if (configs.containsKey("confluent.metrics.reporter.volume.metrics.refresh.ms")) {
            this.volumeMetricsRefreshPeriodMs = Long.parseLong((String)configs.get("confluent.metrics.reporter.volume.metrics.refresh.ms"));
        }
        String logDirsString = null;
        if (configs.containsKey("log.dirs")) {
            logDirsString = (String)configs.get("log.dirs");
        }
        if (logDirsString == null && configs.containsKey("log.dir")) {
            logDirsString = (String)configs.get("log.dir");
        }
        if (logDirsString != null) {
            this.volumeMetricsLogDirs = logDirsString.split("\\s*,\\s*");
        }
    }

    @VisibleForTesting
    protected ConfluentMetric.MetricsMessage.Builder getMetricsMessageBuilder(long timestamp) {
        ConfluentMetric.MetricsMessage.Builder builder = ConfluentMetric.MetricsMessage.newBuilder();
        builder.setMetricType(this.metricType);
        builder.setBrokerId(this.brokerId);
        builder.setClientId(this.clientId);
        builder.setGroupId(this.groupId);
        builder.setClusterId(this.clusterId == null ? "" : this.clusterId);
        builder.setTimestamp(timestamp);
        builder.setVersion(AppInfoParser.getVersion());
        builder.setCommitId(AppInfoParser.getCommitId());
        for (String role : this.processRoles) {
            builder.addProcessRoles(role);
        }
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createTopicIfNotPresent() {
        int publishTopicReplicas = this.metricsReporterConfig.getInt("confluent.metrics.reporter.topic.replicas");
        int publishTopicPartitions = this.metricsReporterConfig.getInt("confluent.metrics.reporter.topic.partitions");
        long retentionMs = this.metricsReporterConfig.getLong("confluent.metrics.reporter.topic.retention.ms");
        long retentionBytes = this.metricsReporterConfig.getLong("confluent.metrics.reporter.topic.retention.bytes");
        long rollMs = this.metricsReporterConfig.getLong("confluent.metrics.reporter.topic.roll.ms");
        int maxMessageBytes = this.metricsReporterConfig.getInt("confluent.metrics.reporter.topic.max.message.bytes");
        try (AdminClient adminClient = AdminClient.create((Properties)this.clientProperties);){
            try {
                adminClient.describeTopics(Collections.singleton(this.publishTopic)).allTopicNames().get();
                log.debug("Metrics reporter topic {} already exists", (Object)this.publishTopic);
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof UnknownTopicOrPartitionException)) {
                    throw e;
                }
                HashMap<String, String> topicConfig = new HashMap<String, String>();
                topicConfig.put("min.insync.replicas", "1");
                topicConfig.put("retention.ms", "" + retentionMs);
                topicConfig.put("retention.bytes", "" + retentionBytes);
                topicConfig.put("segment.ms", "" + rollMs);
                topicConfig.put("max.message.bytes", "" + maxMessageBytes);
                topicConfig.put("message.timestamp.type", TimestampType.CREATE_TIME.name);
                adminClient.createTopics(Collections.singleton(new NewTopic(this.publishTopic, publishTopicPartitions, (short)publishTopicReplicas).configs(topicConfig))).all().get();
                log.info("Created metrics reporter topic {}", (Object)this.publishTopic);
            }
            boolean bl = true;
            return bl;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TopicExistsException) {
                log.info("Attempted to create metrics reporter topic {} but the topic was already created. This may happen the first time ConfluentMetricsReporter is started and multiple brokers attempt to create the topic simultaneously.", (Object)this.publishTopic);
                return true;
            }
            log.error("Error checking or creating metrics topic", e.getCause());
            return false;
        }
        catch (InterruptedException e) {
            log.warn("Confluent metrics reporter topic initialization interrupted");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        log.info("Stopping Confluent metrics reporter");
        this.executor.shutdownNow();
        if (this.producer != null) {
            KafkaProducer<byte[], byte[]> kafkaProducer = this.producer;
            synchronized (kafkaProducer) {
                this.producer.close(Duration.ofMillis(0L));
            }
        }
    }

    public void init(List<KafkaMetric> metrics) {
        log.debug("initializing");
        for (KafkaMetric m4 : metrics) {
            this.metricMap.put(m4.metricName(), m4);
        }
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        if (osBean instanceof com.sun.management.OperatingSystemMXBean) {
            this.osBean = (com.sun.management.OperatingSystemMXBean)osBean;
        } else {
            log.warn("CPU metric is not available on this operating system");
        }
        this.executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.executor.setThreadFactory(new ThreadFactoryBuilder().setNameFormat("confluent-metrics-reporter-scheduler").setDaemon(true).setUncaughtExceptionHandler((t2, e) -> log.error("Uncaught exception in thread '{}':", (Object)t2.getName(), (Object)e)).build());
    }

    public void metricChange(KafkaMetric metric) {
        this.metricMap.put(metric.metricName(), metric);
    }

    public void metricRemoval(KafkaMetric metric) {
        log.debug("removing kafka metric : {}", (Object)metric.metricName());
        this.metricMap.remove(metric.metricName());
    }

    protected Runnable metricReportRunnable() {
        return new MetricReportRunnable();
    }

    @VisibleForTesting
    String clusterId() {
        return this.clusterId;
    }

    static {
        log.debug("available");
    }

    private class MetricReportRunnable
    implements Runnable {
        private boolean isTopicCreated = false;
        private VolumeMetricsProvider volumeMetricsProvider = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.volumeMetricsProvider == null) {
                this.volumeMetricsProvider = new VolumeMetricsProvider(ConfluentMetricsReporter.this.volumeMetricsRefreshPeriodMs, ConfluentMetricsReporter.this.volumeMetricsLogDirs);
            }
            try {
                if (ConfluentMetricsReporter.this.createTopic) {
                    if (!this.isTopicCreated) {
                        this.isTopicCreated = ConfluentMetricsReporter.this.createTopicIfNotPresent();
                    }
                    if (!this.isTopicCreated) {
                        return;
                    }
                }
                log.debug("Begin publishing metrics");
                Iterable<ConfluentMetric.MetricsMessage> metricsMessages = this.genMetricsMessage();
                KafkaProducer kafkaProducer = ConfluentMetricsReporter.this.producer;
                synchronized (kafkaProducer) {
                    if (!Thread.currentThread().isInterrupted()) {
                        for (ConfluentMetric.MetricsMessage metricsMessage : metricsMessages) {
                            log.trace("Generated metric message : {}", (Object)metricsMessage);
                            ConfluentMetricsReporter.this.producer.send(new ProducerRecord(ConfluentMetricsReporter.this.publishTopic, null, Long.valueOf(metricsMessage.getTimestamp()), null, (Object)ConfluentMetricsReporter.this.metricsMessageSerde.serialize(metricsMessage)), new Callback(){

                                public void onCompletion(RecordMetadata metadata, Exception exception) {
                                    if (exception != null) {
                                        log.warn("Failed to produce metrics message", (Throwable)exception);
                                    } else {
                                        log.debug("Produced metrics message of size {} with offset {} to topic partition {}-{}", new Object[]{metadata.serializedValueSize(), metadata.offset(), metadata.topic(), metadata.partition()});
                                    }
                                }
                            });
                        }
                    }
                }
            }
            catch (InterruptException metricsMessages) {
            }
            catch (Throwable t2) {
                log.warn("Failed to publish metrics message in the reporter", t2);
            }
        }

        private Iterable<ConfluentMetric.MetricsMessage> genMetricsMessage() {
            long now = System.currentTimeMillis();
            ArrayList<ConfluentMetric.MetricsMessage> out = new ArrayList<ConfluentMetric.MetricsMessage>();
            ConfluentMetric.MetricsMessage.Builder systemMetricsMessageBuilder = ConfluentMetricsReporter.this.getMetricsMessageBuilder(now);
            ConfluentMetric.SystemMetrics.Builder systemMetricsBuilder = ConfluentMetric.SystemMetrics.newBuilder();
            Collection<VolumeMetricsProvider.VolumeInfo> volumeInfos = this.volumeMetricsProvider.getMetrics().values();
            for (VolumeMetricsProvider.VolumeInfo volumeInfo : volumeInfos) {
                ConfluentMetric.VolumeMetrics.Builder bld = ConfluentMetric.VolumeMetrics.newBuilder();
                bld.setName(volumeInfo.name());
                bld.setTotalBytes(volumeInfo.totalBytes());
                bld.setUsableBytes(volumeInfo.usableBytes());
                for (String logDir : volumeInfo.logDirs()) {
                    bld.addLogDirs(ConfluentMetric.LogDir.newBuilder().setPath(logDir));
                }
                systemMetricsBuilder.addVolumes(bld);
            }
            systemMetricsMessageBuilder.setSystemMetrics(systemMetricsBuilder);
            out.add(systemMetricsMessageBuilder.build());
            MetricsSplitter splitter = new MetricsSplitter(ConfluentMetricsReporter.this.getMetricsMessageBuilder(now).buildPartial());
            splitter.addKafkaMeasurables(KafkaMetricsHelper.collectKafkaMetrics(ConfluentMetricsReporter.this.metricMap, ConfluentMetricsReporter.this.pattern));
            if (ConfluentMetricsReporter.this.metricType == ConfluentMetric.MetricType.BROKER && ConfluentMetricsReporter.this.osBean != null) {
                double cpuUtil = ConfluentMetricsReporter.this.osBean.getProcessCpuLoad();
                ConfluentMetric.KafkaMeasurable.Builder builder = ConfluentMetric.KafkaMeasurable.newBuilder();
                builder.setValue(cpuUtil);
                ConfluentMetric.KafkaMetricName.Builder nameBuilder = ConfluentMetric.KafkaMetricName.newBuilder();
                nameBuilder.setGroup("kafka.server");
                nameBuilder.setName("CpuUsage");
                builder.setMetricName(nameBuilder.build());
                ConfluentMetric.KafkaMeasurable km4 = builder.build();
                ArrayList<ConfluentMetric.KafkaMeasurable> kms = new ArrayList<ConfluentMetric.KafkaMeasurable>();
                kms.add(km4);
                splitter.addKafkaMeasurables(kms);
            }
            if (ConfluentMetricsReporter.this.metricType == ConfluentMetric.MetricType.BROKER) {
                YammerMetricsHelper.YammerMetricsResult yammerMetricsResult = ConfluentMetricsReporter.this.metricsHelper.collectYammerMetrics(METRICS_REGISTRY, ConfluentMetricsReporter.this.pattern);
                splitter.addYammerGauges(yammerMetricsResult.gauges);
                splitter.addYammerMeters(yammerMetricsResult.meters);
                splitter.addYammerHistograms(yammerMetricsResult.histograms);
                splitter.addYammerTimers(yammerMetricsResult.timers);
            }
            out.addAll(splitter.build());
            return out;
        }

        class MetricsSplitter {
            ConfluentMetric.MetricsMessage baseMetricsMessage;
            Map<String, ConfluentMetric.MetricsMessage.Builder> messages = new HashMap<String, ConfluentMetric.MetricsMessage.Builder>();

            public MetricsSplitter(ConfluentMetric.MetricsMessage baseMetricsMessage) {
                this.baseMetricsMessage = baseMetricsMessage;
            }

            ConfluentMetric.MetricsMessage.Builder getBuilder(String metricName) {
                String topic = "";
                try {
                    Map<String, String> tags = YammerMetricsUtils.extractTags(metricName);
                    if (tags.containsKey("topic")) {
                        topic = tags.get("topic");
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (!this.messages.containsKey(topic)) {
                    this.messages.put(topic, ConfluentMetric.MetricsMessage.newBuilder(this.baseMetricsMessage));
                }
                return this.messages.get(topic);
            }

            void addKafkaMeasurables(Collection<ConfluentMetric.KafkaMeasurable> kafkaMeasurables) {
                for (ConfluentMetric.KafkaMeasurable km4 : kafkaMeasurables) {
                    String name = km4.getMetricName().getName();
                    ConfluentMetric.MetricsMessage.Builder builder = this.getBuilder(name);
                    builder.addKafkaMeasurable(km4);
                }
            }

            void addYammerGauges(Collection<ConfluentMetric.YammerGauge> yams) {
                for (ConfluentMetric.YammerGauge yam : yams) {
                    String name = yam.getMetricName().getMBeanName();
                    ConfluentMetric.MetricsMessage.Builder builder = this.getBuilder(name);
                    builder.addYammerGauge(yam);
                }
            }

            void addYammerMeters(Collection<ConfluentMetric.YammerMeter> yams) {
                for (ConfluentMetric.YammerMeter yam : yams) {
                    String name = yam.getMetricName().getMBeanName();
                    ConfluentMetric.MetricsMessage.Builder builder = this.getBuilder(name);
                    builder.addYammerMeter(yam);
                }
            }

            void addYammerHistograms(Collection<ConfluentMetric.YammerHistogram> yams) {
                for (ConfluentMetric.YammerHistogram yam : yams) {
                    String name = yam.getMetricName().getMBeanName();
                    ConfluentMetric.MetricsMessage.Builder builder = this.getBuilder(name);
                    builder.addYammerHistogram(yam);
                }
            }

            void addYammerTimers(Collection<ConfluentMetric.YammerTimer> yams) {
                for (ConfluentMetric.YammerTimer yam : yams) {
                    String name = yam.getMetricName().getMBeanName();
                    ConfluentMetric.MetricsMessage.Builder builder = this.getBuilder(name);
                    builder.addYammerTimer(yam);
                }
            }

            Collection<ConfluentMetric.MetricsMessage> build() {
                return FluentIterable.from(this.messages.values()).transform(new Function<ConfluentMetric.MetricsMessage.Builder, ConfluentMetric.MetricsMessage>(){

                    @Override
                    public ConfluentMetric.MetricsMessage apply(ConfluentMetric.MetricsMessage.Builder input) {
                        return input.build();
                    }
                }).toList();
            }
        }
    }
}

