/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.metrics.reporter;

import io.confluent.shaded.io.confluent.monitoring.common.MonitoringProducerDefaults;
import io.confluent.shaded.io.confluent.monitoring.common.TimeBucket;
import io.confluent.telemetry.common.config.ConfigUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class ConfluentMetricsReporterConfig
extends AbstractConfig {
    public static final String METRICS_REPORTER_PREFIX = "confluent.metrics.reporter.";
    private static final ConfigDef CONFIG;
    public static final String BOOTSTRAP_SERVERS_CONFIG = "confluent.metrics.reporter.bootstrap.servers";
    public static final String BOOTSTRAP_SERVERS_DOC = "Bootstrap servers for the Kafka cluster metrics will be published to. The metrics cluster may be different from the cluster(s) whose metrics are being collected. Several production Kafka clusters can publish to a single metrics cluster, for example.";
    public static final String TOPIC_CONFIG = "confluent.metrics.reporter.topic";
    public static final String DEFAULT_TOPIC_CONFIG = "_confluent-metrics";
    public static final String TOPIC_DOC = "Topic on which metrics data will be written.";
    public static final String TOPIC_CREATE_CONFIG = "confluent.metrics.reporter.topic.create";
    public static final boolean DEFAULT_TOPIC_CREATE_CONFIG = true;
    public static final String TOPIC_CREATE_DOC = "Create the metrics topic if it does not exist.";
    public static final String TOPIC_PARTITIONS_CONFIG = "confluent.metrics.reporter.topic.partitions";
    public static final int DEFAULT_TOPIC_PARTITIONS_CONFIG = 12;
    public static final String TOPIC_PARTITIONS_DOC = "Number of partitions in the metrics topic.";
    public static final String TOPIC_REPLICAS_CONFIG = "confluent.metrics.reporter.topic.replicas";
    public static final int DEFAULT_TOPIC_REPLICAS_CONFIG = 3;
    public static final String TOPIC_REPLICAS_DOC = "Number of replicas in the metric topic. It must not be higher than the number of brokers in the Kafka cluster.";
    public static final int DEFAULT_MIN_ISR = 1;
    public static final String TOPIC_RETENTION_MS_CONFIG = "confluent.metrics.reporter.topic.retention.ms";
    public static final long DEFAULT_TOPIC_RETENTION_MS_CONFIG;
    public static final String TOPIC_RETENTION_MS_DOC = "Retention time for the metrics topic.";
    public static final String TOPIC_RETENTION_BYTES_CONFIG = "confluent.metrics.reporter.topic.retention.bytes";
    public static final long DEFAULT_TOPIC_RETENTION_BYTES_CONFIG = -1L;
    public static final String TOPIC_RETENTION_BYTES_DOC = "Retention bytes for the metrics topic.";
    public static final String TOPIC_ROLL_MS_CONFIG = "confluent.metrics.reporter.topic.roll.ms";
    public static final long DEFAULT_TOPIC_ROLL_MS_CONFIG;
    public static final String TOPIC_ROLL_MS_DOC = "Log rolling time for the metrics topic.";
    public static final String TOPIC_MAX_MESSAGE_BYTES_CONFIG = "confluent.metrics.reporter.topic.max.message.bytes";
    public static final int DEFAULT_TOPIC_MAX_MESSAGE_BYTES_CONFIG = 0xA00000;
    public static final String TOPIC_MAX_MESSAGE_BYTES_DOC = "Maximum message size for the metrics topic.";
    public static final String PUBLISH_PERIOD_CONFIG = "confluent.metrics.reporter.publish.ms";
    public static final Long DEFAULT_PUBLISH_PERIOD;
    public static final String PUBLISH_PERIOD_DOC = "The metrics reporter will publish new metrics to the metrics topic in intervals defined by this setting. This means that control center system health data lags by this duration, or that rebalancer may compute a plan based on broker data that is stale by this duration. The default is a reasonable value for production environments and it typically does not need to be changed.";
    public static final String METRICS_INCLUDE_CONFIG = "confluent.metrics.reporter.include";
    public static final String METRICS_INCLUDE_CONFIG_ALIAS = "confluent.metrics.reporter.whitelist";
    public static final List<String> DEFAULT_BROKER_YAMMER_METRICS;
    public static final List<String> DEFAULT_BROKER_KAFKA_METRICS;
    public static final String DEFAULT_METRICS_INCLUDE;
    public static final String METRICS_INCLUDE_DOC = "Regex matching the yammer metric mbean name or Kafka metric name to be published to the metrics topic.\n\nBy default this includes all the metrics required by Confluent Control Center and Confluent Auto Data Balancer. This should typically never be modified unless requested by Confluent.";
    public static final String VOLUME_METRICS_REFRESH_PERIOD_MS = "confluent.metrics.reporter.volume.metrics.refresh.ms";
    public static final long DEFAULT_VOLUME_METRICS_REFRESH_PERIOD = 15000L;
    public static final String VOLUME_METRICS_REFRESH_PERIOD_DOC = "The minimum interval at which to fetch new volume metrics.";

    private static StringBuilder appendMetricsToBuilder(StringBuilder builder, List<String> metrics, String prefix) {
        Iterator<String> it = metrics.iterator();
        if (it.hasNext()) {
            if (builder.length() > 0) {
                builder.append("|");
            }
            builder.append(".*" + prefix + "(");
            builder.append(it.next());
            while (it.hasNext()) {
                builder.append("|");
                builder.append(it.next());
            }
            builder.append(").*");
        }
        return builder;
    }

    public ConfluentMetricsReporterConfig(Map<String, ?> clientConfigs) {
        super(CONFIG, ConfigUtils.translateDeprecated(clientConfigs, new String[][]{{METRICS_INCLUDE_CONFIG, METRICS_INCLUDE_CONFIG_ALIAS}}));
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toRst());
    }

    private static Map<String, Object> producerConfigDefaults() {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.putAll(MonitoringProducerDefaults.PRODUCER_CONFIG_DEFAULTS);
        defaults.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        defaults.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        defaults.put("enable.idempotence", "false");
        defaults.put("client.id", "confluent-metrics-reporter");
        return defaults;
    }

    static Properties getProducerProperties(Map<String, ?> clientConfigs) {
        Properties props = new Properties();
        props.putAll(ConfluentMetricsReporterConfig.producerConfigDefaults());
        props.putAll((Map<?, ?>)ConfluentMetricsReporterConfig.getClientProperties(clientConfigs));
        return props;
    }

    static Properties getClientProperties(Map<String, ?> clientConfigs) {
        Properties props = new Properties();
        for (Map.Entry<String, ?> entry : clientConfigs.entrySet()) {
            if (!entry.getKey().startsWith(METRICS_REPORTER_PREFIX)) continue;
            props.put(entry.getKey().substring(METRICS_REPORTER_PREFIX.length()), entry.getValue());
        }
        Object bootstrap = props.get("bootstrap.servers");
        if (bootstrap == null) {
            throw new ConfigException("Missing required property confluent.metrics.reporter.bootstrap.servers");
        }
        return props;
    }

    static {
        DEFAULT_TOPIC_RETENTION_MS_CONFIG = TimeUnit.DAYS.toMillis(3L);
        DEFAULT_TOPIC_ROLL_MS_CONFIG = TimeUnit.HOURS.toMillis(4L);
        DEFAULT_PUBLISH_PERIOD = TimeBucket.SIZE;
        DEFAULT_BROKER_YAMMER_METRICS = Collections.unmodifiableList(Arrays.asList("ActiveControllerCount", "BytesInPerSec", "BytesOutPerSec", "CaughtUpReplicasCount", "FailedFetchRequestsPerSec", "FailedProduceRequestsPerSec", "InSyncReplicasCount", "LeaderCount", "LeaderElectionRateAndTimeMs", "LocalTimeMs", "LogEndOffset", "LogStartOffset", "NetworkProcessorAvgIdlePercent", "NumLogSegments", "NumPartitionsInError", "OfflinePartitionsCount", "ObserverReplicasCount", "PartitionCount", "RemoteTimeMs", "ReplicasCount", "RequestHandlerAvgIdlePercent", "RequestQueueSize", "RequestQueueTimeMs", "RequestsPerSec", "ResponseQueueSize", "ResponseQueueTimeMs", "ResponseSendTimeMs", "Size", "TierSize", "TotalFetchRequestsPerSec", "TotalLag", "TotalProduceRequestsPerSec", "TotalSize", "TotalTimeMs", "UncleanLeaderElectionsPerSec", "UnderReplicated", "UnderReplicatedPartitions", "UnderMinIsrPartitionCount", "ZooKeeperDisconnectsPerSec", "ZooKeeperExpiresPerSec", "TieredPartitionsUndergoingUncleanLeaderRecoveryCount", "NonTieredPartitionsUndergoingUncleanLeaderRecoveryCount", "TierTopicPartitionsUndergoingUncleanLeaderRecoveryCount", "ContiguousUnhealthySamples", "ContiguousSamplesEngineThreadGroupsStuck", "ContiguousSamplesStorageThreadGroupsStuck", "ContiguousSamplesNoStorageThreadMakingProgress"));
        DEFAULT_BROKER_KAFKA_METRICS = Collections.unmodifiableList(Arrays.asList("BytesFetchedRate"));
        StringBuilder builder = new StringBuilder(".*MaxLag.*|kafka.log:type=Log,name=Size.*");
        ConfluentMetricsReporterConfig.appendMetricsToBuilder(builder, DEFAULT_BROKER_YAMMER_METRICS, "name=");
        ConfluentMetricsReporterConfig.appendMetricsToBuilder(builder, DEFAULT_BROKER_KAFKA_METRICS, "");
        DEFAULT_METRICS_INCLUDE = builder.toString();
        CONFIG = new ConfigDef().define(BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, BOOTSTRAP_SERVERS_DOC).define(TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_TOPIC_CONFIG, ConfigDef.Importance.LOW, TOPIC_DOC).define(TOPIC_CREATE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, TOPIC_CREATE_DOC).define(TOPIC_PARTITIONS_CONFIG, ConfigDef.Type.INT, (Object)12, ConfigDef.Importance.LOW, TOPIC_PARTITIONS_DOC).define(TOPIC_REPLICAS_CONFIG, ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.LOW, TOPIC_REPLICAS_DOC).define(TOPIC_RETENTION_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_TOPIC_RETENTION_MS_CONFIG, ConfigDef.Importance.LOW, TOPIC_RETENTION_MS_DOC).define(TOPIC_RETENTION_BYTES_CONFIG, ConfigDef.Type.LONG, (Object)-1L, ConfigDef.Importance.LOW, TOPIC_RETENTION_BYTES_DOC).define(TOPIC_ROLL_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_TOPIC_ROLL_MS_CONFIG, ConfigDef.Importance.LOW, TOPIC_ROLL_MS_DOC).define(TOPIC_MAX_MESSAGE_BYTES_CONFIG, ConfigDef.Type.INT, (Object)0xA00000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, TOPIC_MAX_MESSAGE_BYTES_DOC).define(PUBLISH_PERIOD_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_PUBLISH_PERIOD, ConfigDef.Importance.LOW, PUBLISH_PERIOD_DOC).define(METRICS_INCLUDE_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_METRICS_INCLUDE, ConfigDef.Importance.LOW, METRICS_INCLUDE_DOC).define(METRICS_INCLUDE_CONFIG_ALIAS, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "Deprecated, use confluent.metrics.reporter.include instead.").define(VOLUME_METRICS_REFRESH_PERIOD_MS, ConfigDef.Type.LONG, (Object)15000L, ConfigDef.Importance.LOW, VOLUME_METRICS_REFRESH_PERIOD_DOC);
    }
}

