/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.com.google.common.collect;

import io.confluent.shaded.com.google.common.annotations.GwtCompatible;
import io.confluent.shaded.com.google.common.base.Preconditions;
import io.confluent.shaded.com.google.common.collect.AbstractIterator;
import io.confluent.shaded.com.google.common.collect.ElementTypesAreNonnullByDefault;
import io.confluent.shaded.javax.annotation.CheckForNull;
import java.util.Queue;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    @CheckForNull
    protected T computeNext() {
        if (this.queue.isEmpty()) {
            return this.endOfData();
        }
        return this.queue.remove();
    }
}

