/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.com.hubspot.jackson.datatype.protobuf;

import io.confluent.shaded.com.fasterxml.jackson.core.JsonParser;
import io.confluent.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.confluent.shaded.com.fasterxml.jackson.core.JsonToken;
import io.confluent.shaded.com.fasterxml.jackson.core.io.NumberInput;
import io.confluent.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.confluent.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.confluent.shaded.com.fasterxml.jackson.databind.JavaType;
import io.confluent.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import io.confluent.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import io.confluent.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.confluent.shaded.com.google.common.base.Function;
import io.confluent.shaded.com.google.common.base.Joiner;
import io.confluent.shaded.com.google.common.collect.Lists;
import io.confluent.shaded.com.google.protobuf.ByteString;
import io.confluent.shaded.com.google.protobuf.Descriptors;
import io.confluent.shaded.com.google.protobuf.Message;
import io.confluent.shaded.com.google.protobuf.NullValue;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.BuildingDeserializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.deserializers.MessageDeserializer;
import io.confluent.shaded.edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.shaded.javax.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ProtobufDeserializer<T extends Message, V extends Message.Builder>
extends StdDeserializer<V> {
    private static final String NULL_VALUE_FULL_NAME = NullValue.getDescriptor().getFullName();
    private static final Descriptors.EnumValueDescriptor NULL_VALUE_DESCRIPTOR = NullValue.NULL_VALUE.getValueDescriptor();
    private final T defaultInstance;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final Map<Descriptors.FieldDescriptor, JsonDeserializer<Object>> deserializerCache;

    public ProtobufDeserializer(Class<T> messageType) {
        super(messageType);
        try {
            this.defaultInstance = (Message)messageType.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get default instance for type " + messageType, e);
        }
        this.deserializerCache = new ConcurrentHashMap<Descriptors.FieldDescriptor, JsonDeserializer<Object>>();
    }

    protected abstract void populate(V var1, JsonParser var2, DeserializationContext var3) throws IOException;

    public JsonDeserializer<T> buildAtEnd() {
        Class<?> messageType = this.handledType();
        return new BuildingDeserializer<T, V>(messageType){

            @Override
            public JsonDeserializer<V> getWrappedDeserializer() {
                return ProtobufDeserializer.this;
            }
        };
    }

    @Override
    public V deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        Message.Builder builder = this.defaultInstance.newBuilderForType();
        this.populate(builder, parser, context);
        return (V)builder;
    }

    private void checkNullReturn(Descriptors.FieldDescriptor field, DeserializationContext context) throws JsonProcessingException {
        if (context.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            throw this.reportInputMismatch(context, "Can not map JSON null into primitive field " + field.getFullName() + " (set DeserializationConfig.DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES to 'false' to allow)");
        }
    }

    protected List<Message> readMap(Message.Builder builder, Descriptors.FieldDescriptor field, JsonParser parser, DeserializationContext context) throws IOException {
        if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
            return Collections.emptyList();
        }
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw this.reportWrongToken(JsonToken.START_OBJECT, context, "Can't parse map field out of " + (Object)((Object)parser.currentToken()) + " token");
        }
        Descriptors.Descriptor entryDescriptor = field.getMessageType();
        Descriptors.FieldDescriptor keyDescriptor = entryDescriptor.findFieldByName("key");
        Descriptors.FieldDescriptor valueDescriptor = entryDescriptor.findFieldByName("value");
        ArrayList<Message> entries = new ArrayList<Message>();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            Message.Builder entryBuilder = builder.newBuilderForField(field);
            Object key = this.readKey(keyDescriptor, parser, context);
            parser.nextToken();
            Object value = this.readValue(entryBuilder, valueDescriptor, null, parser, context);
            entryBuilder.setField(keyDescriptor, key);
            entryBuilder.setField(valueDescriptor, value);
            entries.add(entryBuilder.build());
        }
        return entries;
    }

    private Object readKey(Descriptors.FieldDescriptor field, JsonParser parser, DeserializationContext context) throws IOException {
        if (parser.getCurrentToken() != JsonToken.FIELD_NAME) {
            throw this.reportWrongToken(JsonToken.FIELD_NAME, context, "Expected FIELD_NAME token");
        }
        String fieldName = parser.getCurrentName();
        switch (field.getJavaType()) {
            case INT: {
                try {
                    return NumberInput.parseInt(fieldName.trim());
                }
                catch (IllegalArgumentException iae) {
                    Number number = (Number)context.handleWeirdStringValue(this._valueClass, fieldName.trim(), "not a valid int value", new Object[0]);
                    return number == null ? 0 : number.intValue();
                }
            }
            case LONG: {
                try {
                    return NumberInput.parseLong(fieldName.trim());
                }
                catch (IllegalArgumentException iae) {
                    Number number = (Number)context.handleWeirdStringValue(this._valueClass, fieldName.trim(), "not a valid long value", new Object[0]);
                    return number == null ? 0L : number.longValue();
                }
            }
            case BOOLEAN: {
                String text = fieldName.trim();
                if ("true".equals(text) || "True".equals(text)) {
                    return true;
                }
                if ("false".equals(text) || "False".equals(text)) {
                    return false;
                }
                Boolean b = (Boolean)context.handleWeirdStringValue(this._valueClass, text, "only \"true\" or \"false\" recognized", new Object[0]);
                return Boolean.TRUE.equals(b);
            }
            case STRING: {
                return fieldName;
            }
            case ENUM: {
                Descriptors.EnumValueDescriptor enumValueDescriptor = field.getEnumType().findValueByName(parser.getText());
                if (enumValueDescriptor == null && !ProtobufDeserializer.ignorableEnum(parser.getText().trim(), context)) {
                    throw context.weirdStringException(parser.getText(), field.getEnumType().getClass(), "value not one of declared Enum instance names");
                }
                return enumValueDescriptor;
            }
        }
        throw new IllegalArgumentException("Unexpected map key type: " + (Object)((Object)field.getJavaType()));
    }

    protected Object readValue(Message.Builder builder, Descriptors.FieldDescriptor field, Message defaultInstance, JsonParser parser, DeserializationContext context) throws IOException {
        if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
            JsonDeserializer<Object> deserializer;
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && !ProtobufDeserializer.isDefaultMessageDeserializer(deserializer = this.getMessageDeserializer(builder, field, defaultInstance, context))) {
                return deserializer.deserialize(parser, context);
            }
            throw this.reportInputMismatch(context, "Encountered START_ARRAY token for non-repeated field " + field.getFullName());
        }
        if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
            switch (field.getJavaType()) {
                case INT: 
                case LONG: 
                case BOOLEAN: 
                case FLOAT: 
                case DOUBLE: {
                    this.checkNullReturn(field, context);
                    return null;
                }
                case ENUM: {
                    if (NULL_VALUE_FULL_NAME.equals(field.getEnumType().getFullName())) {
                        return NULL_VALUE_DESCRIPTOR;
                    }
                    return null;
                }
                case MESSAGE: {
                    JsonDeserializer<Object> deserializer = this.getMessageDeserializer(builder, field, defaultInstance, context);
                    return deserializer.getNullValue(context);
                }
            }
            return null;
        }
        switch (field.getJavaType()) {
            case INT: {
                return this._parseIntPrimitive(parser, context);
            }
            case LONG: {
                return this._parseLongPrimitive(parser, context);
            }
            case FLOAT: {
                return Float.valueOf(this._parseFloatPrimitive(parser, context));
            }
            case DOUBLE: {
                return this._parseDoublePrimitive(parser, context);
            }
            case BOOLEAN: {
                return this._parseBooleanPrimitive(parser, context);
            }
            case STRING: {
                switch (parser.getCurrentToken()) {
                    case VALUE_STRING: {
                        return parser.getText();
                    }
                }
                return this._parseString(parser, context);
            }
            case BYTE_STRING: {
                switch (parser.getCurrentToken()) {
                    case VALUE_STRING: {
                        return ByteString.copyFrom(context.getBase64Variant().decode(parser.getText()));
                    }
                }
                throw this.reportWrongToken(field, JsonToken.VALUE_STRING, context);
            }
            case ENUM: {
                switch (parser.getCurrentToken()) {
                    case VALUE_STRING: {
                        Descriptors.EnumValueDescriptor enumValueDescriptor = field.getEnumType().findValueByName(parser.getText());
                        if (enumValueDescriptor == null && !ProtobufDeserializer.ignorableEnum(parser.getText().trim(), context)) {
                            throw context.weirdStringException(parser.getText(), field.getEnumType().getClass(), "value not one of declared Enum instance names");
                        }
                        return enumValueDescriptor;
                    }
                    case VALUE_NUMBER_INT: {
                        if (ProtobufDeserializer.allowNumbersForEnums(context)) {
                            Descriptors.EnumValueDescriptor enumValueDescriptor = field.getEnumType().findValueByNumber(parser.getIntValue());
                            if (enumValueDescriptor == null && !ProtobufDeserializer.ignoreUnknownEnums(context)) {
                                throw context.weirdNumberException(parser.getIntValue(), field.getEnumType().getClass(), "index value outside legal index range " + ProtobufDeserializer.indexRange(field.getEnumType()));
                            }
                            return enumValueDescriptor;
                        }
                        throw this.reportWrongToken(JsonToken.VALUE_STRING, context, "Not allowed to deserialize Enum value out of JSON number (disable DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS to allow)");
                    }
                }
                throw this.reportWrongToken(field, JsonToken.VALUE_STRING, context);
            }
            case MESSAGE: {
                JsonDeserializer<Object> deserializer = this.getMessageDeserializer(builder, field, defaultInstance, context);
                return deserializer.deserialize(parser, context);
            }
        }
        throw new IllegalArgumentException("Unrecognized field type: " + (Object)((Object)field.getJavaType()));
    }

    protected List<Object> readArray(Message.Builder builder, Descriptors.FieldDescriptor field, Message defaultInstance, JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentToken()) {
            case START_ARRAY: {
                ArrayList<Object> values = Lists.newArrayList();
                while (parser.nextToken() != JsonToken.END_ARRAY) {
                    Object value = this.readValue(builder, field, defaultInstance, parser, context);
                    if (value == null) continue;
                    values.add(value);
                }
                return values;
            }
            case VALUE_NULL: {
                return Collections.emptyList();
            }
        }
        if (context.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            Object value = this.readValue(builder, field, defaultInstance, parser, context);
            return Collections.singletonList(value);
        }
        throw this.reportInputMismatch(context, "Expected JSON array for repeated field " + field.getFullName());
    }

    private JsonDeserializer<Object> getMessageDeserializer(Message.Builder builder, Descriptors.FieldDescriptor field, Message defaultInstance, DeserializationContext context) throws IOException {
        JsonDeserializer<Object> deserializer = this.deserializerCache.get(field);
        if (deserializer == null) {
            Class<?> subType;
            if (defaultInstance == null) {
                Message.Builder subBuilder = builder.newBuilderForField(field);
                subType = subBuilder.getDefaultInstanceForType().getClass();
            } else {
                subType = defaultInstance.getClass();
            }
            JavaType type = context.constructType(subType);
            deserializer = context.findContextualValueDeserializer(type, null);
            this.deserializerCache.put(field, deserializer);
        }
        return deserializer;
    }

    private AssertionError reportInputMismatch(DeserializationContext context, String message) throws JsonMappingException {
        context.reportInputMismatch(this, message, new Object[0]);
        throw new AssertionError();
    }

    private AssertionError reportWrongToken(Descriptors.FieldDescriptor field, JsonToken expected, DeserializationContext context) throws JsonMappingException {
        return this.reportWrongToken(expected, context, ProtobufDeserializer.wrongTokenMessage(field, context));
    }

    private AssertionError reportWrongToken(JsonToken expected, DeserializationContext context, String message) throws JsonMappingException {
        context.reportWrongTokenException(this, expected, message, new Object[0]);
        throw new AssertionError();
    }

    private static boolean isDefaultMessageDeserializer(JsonDeserializer<?> deserializer) {
        Class<?> deserializerType = deserializer instanceof BuildingDeserializer ? ((BuildingDeserializer)deserializer).getWrappedDeserializer().getClass() : deserializer.getClass();
        return MessageDeserializer.class.equals(deserializerType);
    }

    private static boolean ignorableEnum(String value, DeserializationContext context) {
        return ProtobufDeserializer.acceptEmptyStringAsNull(context) && value.length() == 0 || ProtobufDeserializer.ignoreUnknownEnums(context);
    }

    private static boolean acceptEmptyStringAsNull(DeserializationContext context) {
        return context.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
    }

    private static boolean allowNumbersForEnums(DeserializationContext context) {
        return !context.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS);
    }

    private static boolean ignoreUnknownEnums(DeserializationContext context) {
        return context.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);
    }

    private static String indexRange(Descriptors.EnumDescriptor field) {
        List<Integer> indices = Lists.transform(field.getValues(), new Function<Descriptors.EnumValueDescriptor, Integer>(){

            @Override
            public Integer apply(@Nonnull Descriptors.EnumValueDescriptor value) {
                return value.getIndex();
            }
        });
        indices = Lists.newArrayList(indices);
        Collections.sort(indices);
        return "[" + Joiner.on(',').join(indices) + "]";
    }

    private static String wrongTokenMessage(Descriptors.FieldDescriptor field, DeserializationContext context) {
        return "Can not deserialize instance of " + (Object)((Object)field.getJavaType()) + " out of " + (Object)((Object)context.getParser().currentToken()) + " token";
    }
}

