/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.com.hubspot.jackson.datatype.protobuf;

import io.confluent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.confluent.shaded.com.fasterxml.jackson.core.Version;
import io.confluent.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import io.confluent.shaded.com.fasterxml.jackson.databind.Module;
import io.confluent.shaded.com.fasterxml.jackson.databind.module.SimpleDeserializers;
import io.confluent.shaded.com.fasterxml.jackson.databind.module.SimpleSerializers;
import io.confluent.shaded.com.google.protobuf.BoolValue;
import io.confluent.shaded.com.google.protobuf.BytesValue;
import io.confluent.shaded.com.google.protobuf.DoubleValue;
import io.confluent.shaded.com.google.protobuf.Duration;
import io.confluent.shaded.com.google.protobuf.ExtensionRegistry;
import io.confluent.shaded.com.google.protobuf.FieldMask;
import io.confluent.shaded.com.google.protobuf.FloatValue;
import io.confluent.shaded.com.google.protobuf.Int32Value;
import io.confluent.shaded.com.google.protobuf.Int64Value;
import io.confluent.shaded.com.google.protobuf.ListValue;
import io.confluent.shaded.com.google.protobuf.Message;
import io.confluent.shaded.com.google.protobuf.MessageOrBuilder;
import io.confluent.shaded.com.google.protobuf.NullValue;
import io.confluent.shaded.com.google.protobuf.StringValue;
import io.confluent.shaded.com.google.protobuf.Struct;
import io.confluent.shaded.com.google.protobuf.Timestamp;
import io.confluent.shaded.com.google.protobuf.UInt32Value;
import io.confluent.shaded.com.google.protobuf.UInt64Value;
import io.confluent.shaded.com.google.protobuf.Value;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.MessageDeserializerFactory;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.deserializers.DurationDeserializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.deserializers.FieldMaskDeserializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.deserializers.ListValueDeserializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.deserializers.NullValueDeserializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.deserializers.StructDeserializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.deserializers.TimestampDeserializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.deserializers.ValueDeserializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.deserializers.WrappedPrimitiveDeserializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.serializers.DurationSerializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.serializers.FieldMaskSerializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.serializers.ListValueSerializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.serializers.MessageSerializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.serializers.NullValueSerializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.serializers.StructSerializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.serializers.TimestampSerializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.serializers.ValueSerializer;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.serializers.WrappedPrimitiveSerializer;

public class ProtobufModule
extends Module {
    private final ProtobufJacksonConfig config;

    public ProtobufModule() {
        this(ProtobufJacksonConfig.builder().build());
    }

    @Deprecated
    public ProtobufModule(ExtensionRegistry extensionRegistry) {
        this(ProtobufJacksonConfig.builder().extensionRegistry(extensionRegistry).build());
    }

    public ProtobufModule(ProtobufJacksonConfig config) {
        this.config = config;
    }

    @Override
    public String getModuleName() {
        return "ProtobufModule";
    }

    @Override
    public Version version() {
        return Version.unknownVersion();
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        SimpleSerializers serializers = new SimpleSerializers();
        serializers.addSerializer(new MessageSerializer(this.config));
        serializers.addSerializer(new DurationSerializer());
        serializers.addSerializer(new FieldMaskSerializer());
        serializers.addSerializer(new ListValueSerializer());
        serializers.addSerializer(new NullValueSerializer());
        serializers.addSerializer(new StructSerializer());
        serializers.addSerializer(new TimestampSerializer());
        serializers.addSerializer(new ValueSerializer());
        serializers.addSerializer(new WrappedPrimitiveSerializer<DoubleValue>(DoubleValue.class));
        serializers.addSerializer(new WrappedPrimitiveSerializer<FloatValue>(FloatValue.class));
        serializers.addSerializer(new WrappedPrimitiveSerializer<Int64Value>(Int64Value.class));
        serializers.addSerializer(new WrappedPrimitiveSerializer<UInt64Value>(UInt64Value.class));
        serializers.addSerializer(new WrappedPrimitiveSerializer<Int32Value>(Int32Value.class));
        serializers.addSerializer(new WrappedPrimitiveSerializer<UInt32Value>(UInt32Value.class));
        serializers.addSerializer(new WrappedPrimitiveSerializer<BoolValue>(BoolValue.class));
        serializers.addSerializer(new WrappedPrimitiveSerializer<StringValue>(StringValue.class));
        serializers.addSerializer(new WrappedPrimitiveSerializer<BytesValue>(BytesValue.class));
        context.addSerializers(serializers);
        context.addDeserializers(new MessageDeserializerFactory(this.config));
        SimpleDeserializers deserializers = new SimpleDeserializers();
        deserializers.addDeserializer(Duration.class, new DurationDeserializer());
        deserializers.addDeserializer(FieldMask.class, new FieldMaskDeserializer());
        deserializers.addDeserializer(ListValue.class, new ListValueDeserializer().buildAtEnd());
        deserializers.addDeserializer(NullValue.class, new NullValueDeserializer());
        deserializers.addDeserializer(Struct.class, new StructDeserializer().buildAtEnd());
        deserializers.addDeserializer(Timestamp.class, new TimestampDeserializer());
        deserializers.addDeserializer(Value.class, new ValueDeserializer().buildAtEnd());
        deserializers.addDeserializer(DoubleValue.class, ProtobufModule.wrappedPrimitiveDeserializer(DoubleValue.class));
        deserializers.addDeserializer(FloatValue.class, ProtobufModule.wrappedPrimitiveDeserializer(FloatValue.class));
        deserializers.addDeserializer(Int64Value.class, ProtobufModule.wrappedPrimitiveDeserializer(Int64Value.class));
        deserializers.addDeserializer(UInt64Value.class, ProtobufModule.wrappedPrimitiveDeserializer(UInt64Value.class));
        deserializers.addDeserializer(Int32Value.class, ProtobufModule.wrappedPrimitiveDeserializer(Int32Value.class));
        deserializers.addDeserializer(UInt32Value.class, ProtobufModule.wrappedPrimitiveDeserializer(UInt32Value.class));
        deserializers.addDeserializer(BoolValue.class, ProtobufModule.wrappedPrimitiveDeserializer(BoolValue.class));
        deserializers.addDeserializer(StringValue.class, ProtobufModule.wrappedPrimitiveDeserializer(StringValue.class));
        deserializers.addDeserializer(BytesValue.class, ProtobufModule.wrappedPrimitiveDeserializer(BytesValue.class));
        context.addDeserializers(deserializers);
        context.setMixInAnnotations(MessageOrBuilder.class, MessageOrBuilderMixin.class);
    }

    private static <T extends Message> JsonDeserializer<T> wrappedPrimitiveDeserializer(Class<T> type) {
        return new WrappedPrimitiveDeserializer(type).buildAtEnd();
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    private static class MessageOrBuilderMixin {
        private MessageOrBuilderMixin() {
        }
    }
}

