/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.deserializers;

import io.confluent.shaded.com.fasterxml.jackson.core.JsonParser;
import io.confluent.shaded.com.fasterxml.jackson.core.JsonToken;
import io.confluent.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.confluent.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.confluent.shaded.com.google.protobuf.Duration;
import io.confluent.shaded.com.google.protobuf.util.Durations;
import java.io.IOException;
import java.text.ParseException;

public class DurationDeserializer
extends StdDeserializer<Duration> {
    public DurationDeserializer() {
        super(Duration.class);
    }

    @Override
    public Duration deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentToken()) {
            case VALUE_STRING: {
                try {
                    return Durations.parse(parser.getText());
                }
                catch (ParseException e) {
                    throw context.weirdStringException(parser.getText(), Duration.class, e.getMessage());
                }
            }
        }
        context.reportWrongTokenException(Duration.class, JsonToken.VALUE_STRING, DurationDeserializer.wrongTokenMessage(context), new Object[0]);
        throw new AssertionError();
    }

    private static String wrongTokenMessage(DeserializationContext context) {
        return "Can not deserialize instance of com.google.protobuf.Duration out of " + (Object)((Object)context.getParser().currentToken()) + " token";
    }
}

