/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.builtin.deserializers;

import io.confluent.shaded.com.fasterxml.jackson.core.JsonParser;
import io.confluent.shaded.com.fasterxml.jackson.core.JsonToken;
import io.confluent.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.confluent.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.confluent.shaded.com.google.protobuf.Timestamp;
import io.confluent.shaded.com.google.protobuf.util.Timestamps;
import java.io.IOException;
import java.text.ParseException;

public class TimestampDeserializer
extends StdDeserializer<Timestamp> {
    public TimestampDeserializer() {
        super(Timestamp.class);
    }

    @Override
    public Timestamp deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentToken()) {
            case VALUE_STRING: {
                try {
                    return Timestamps.parse(parser.getText());
                }
                catch (ParseException e) {
                    throw context.weirdStringException(parser.getText(), Timestamp.class, e.getMessage());
                }
            }
        }
        context.reportWrongTokenException(Timestamp.class, JsonToken.VALUE_STRING, TimestampDeserializer.wrongTokenMessage(context), new Object[0]);
        throw new AssertionError();
    }

    private static String wrongTokenMessage(DeserializationContext context) {
        return "Can not deserialize instance of com.google.protobuf.Timestamp out of " + (Object)((Object)context.getParser().currentToken()) + " token";
    }
}

