/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.core;

import io.confluent.shaded.io.cloudevents.CloudEvent;
import io.confluent.shaded.io.cloudevents.CloudEventContext;
import io.confluent.shaded.io.cloudevents.CloudEventData;
import io.confluent.shaded.io.cloudevents.core.builder.CloudEventBuilder;
import io.confluent.shaded.io.cloudevents.core.impl.CloudEventContextReaderAdapter;
import io.confluent.shaded.io.cloudevents.core.impl.CloudEventReaderAdapter;
import io.confluent.shaded.io.cloudevents.lang.Nullable;
import io.confluent.shaded.io.cloudevents.rw.CloudEventContextReader;
import io.confluent.shaded.io.cloudevents.rw.CloudEventDataMapper;
import io.confluent.shaded.io.cloudevents.rw.CloudEventRWException;
import io.confluent.shaded.io.cloudevents.rw.CloudEventReader;

public final class CloudEventUtils {
    private CloudEventUtils() {
    }

    public static CloudEventReader toReader(CloudEvent event) {
        if (event instanceof CloudEventReader) {
            return (CloudEventReader)((Object)event);
        }
        return new CloudEventReaderAdapter(event);
    }

    public static CloudEventContextReader toContextReader(CloudEventContext event) {
        if (event instanceof CloudEventContextReader) {
            return (CloudEventContextReader)((Object)event);
        }
        return new CloudEventContextReaderAdapter(event);
    }

    public static CloudEvent toEvent(CloudEventReader reader) throws CloudEventRWException {
        return CloudEventUtils.toEvent(reader, CloudEventDataMapper.identity());
    }

    public static CloudEvent toEvent(CloudEventReader reader, CloudEventDataMapper<?> mapper) throws CloudEventRWException {
        return (CloudEvent)reader.read(CloudEventBuilder::fromSpecVersion, mapper);
    }

    @Nullable
    public static <R extends CloudEventData> R mapData(CloudEvent event, CloudEventDataMapper<R> mapper) {
        CloudEventData data = event.getData();
        if (data == null) {
            return null;
        }
        return mapper.map(data);
    }
}

