/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.core.data;

import io.confluent.shaded.io.cloudevents.CloudEventData;
import io.confluent.shaded.io.cloudevents.rw.CloudEventRWException;
import java.util.Objects;

public class PojoCloudEventData<T>
implements CloudEventData {
    private final T value;
    private byte[] memoizedValue;
    private final ToBytes<T> mapper;

    private PojoCloudEventData(T value, ToBytes<T> mapper) {
        this(value, null, mapper);
    }

    private PojoCloudEventData(T value, byte[] memoizedValue, ToBytes<T> mapper) {
        Objects.requireNonNull(value);
        if (memoizedValue == null && mapper == null) {
            throw new NullPointerException("You must provide the serialized data value or a mapper");
        }
        this.value = value;
        this.memoizedValue = memoizedValue;
        this.mapper = mapper;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public byte[] toBytes() {
        if (this.memoizedValue == null) {
            try {
                this.memoizedValue = this.mapper.convert(this.value);
            }
            catch (Exception e) {
                throw CloudEventRWException.newDataConversion(e, this.value.getClass().toString(), "byte[]");
            }
        }
        return this.memoizedValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PojoCloudEventData that = (PojoCloudEventData)o;
        return Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }

    public static <T> PojoCloudEventData<T> wrap(T data, ToBytes<T> mapper) {
        return new PojoCloudEventData<T>(data, mapper);
    }

    @FunctionalInterface
    public static interface ToBytes<T> {
        public byte[] convert(T var1) throws Exception;
    }
}

