/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.core.message.impl;

import io.confluent.shaded.io.cloudevents.CloudEvent;
import io.confluent.shaded.io.cloudevents.core.format.EventFormat;
import io.confluent.shaded.io.cloudevents.core.message.StructuredMessageWriter;
import io.confluent.shaded.io.cloudevents.core.message.impl.BaseStructuredMessageReader;
import io.confluent.shaded.io.cloudevents.core.provider.EventFormatProvider;
import io.confluent.shaded.io.cloudevents.lang.Nullable;
import io.confluent.shaded.io.cloudevents.rw.CloudEventRWException;

public class GenericStructuredMessageReader
extends BaseStructuredMessageReader {
    private final EventFormat format;
    private final byte[] payload;

    public GenericStructuredMessageReader(EventFormat format, byte[] payload) {
        this.format = format;
        this.payload = payload;
    }

    public <T> T read(StructuredMessageWriter<T> writer) throws CloudEventRWException, IllegalStateException {
        return writer.setEvent(this.format, this.payload);
    }

    public static GenericStructuredMessageReader fromContentType(String contentType, byte[] payload) {
        EventFormat format = EventFormatProvider.getInstance().resolveFormat(contentType);
        if (format == null) {
            return null;
        }
        return new GenericStructuredMessageReader(format, payload);
    }

    @Nullable
    public static GenericStructuredMessageReader from(CloudEvent event, String contentType) {
        EventFormat format = EventFormatProvider.getInstance().resolveFormat(contentType);
        if (format == null) {
            return null;
        }
        return GenericStructuredMessageReader.from(event, format);
    }

    public static GenericStructuredMessageReader from(CloudEvent event, EventFormat format) {
        return new GenericStructuredMessageReader(format, format.serialize(event));
    }
}

