/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.kafka;

import io.confluent.shaded.io.cloudevents.CloudEvent;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class PartitionKeyExtensionInterceptor
implements ProducerInterceptor<Object, CloudEvent> {
    public static final String PARTITION_KEY_EXTENSION = "partitionkey";

    public ProducerRecord<Object, CloudEvent> onSend(ProducerRecord<Object, CloudEvent> record) {
        if (record.value() == null) {
            return record;
        }
        Object partitionKey = ((CloudEvent)record.value()).getExtension(PARTITION_KEY_EXTENSION);
        if (partitionKey == null) {
            return record;
        }
        return new ProducerRecord(record.topic(), record.partition(), record.timestamp(), partitionKey, record.value(), (Iterable)record.headers());
    }

    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
    }
}

