/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.cloudevents.rw;

import io.confluent.shaded.io.cloudevents.lang.Nullable;

public class CloudEventRWException
extends RuntimeException {
    private final CloudEventRWExceptionKind kind;

    private CloudEventRWException(CloudEventRWExceptionKind kind, Throwable cause) {
        super(cause);
        this.kind = kind;
    }

    private CloudEventRWException(CloudEventRWExceptionKind kind, String message) {
        super(message);
        this.kind = kind;
    }

    private CloudEventRWException(CloudEventRWExceptionKind kind, String message, Throwable cause) {
        super(message, cause);
        this.kind = kind;
    }

    public CloudEventRWExceptionKind getKind() {
        return this.kind;
    }

    public static CloudEventRWException newInvalidSpecVersion(String specVersion) {
        return new CloudEventRWException(CloudEventRWExceptionKind.INVALID_SPEC_VERSION, "Invalid specversion: " + specVersion);
    }

    public static CloudEventRWException newInvalidAttributeName(String attributeName) {
        return new CloudEventRWException(CloudEventRWExceptionKind.INVALID_ATTRIBUTE_NAME, "Invalid attribute: " + attributeName);
    }

    public static CloudEventRWException newInvalidExtensionName(String extensionName) {
        return new CloudEventRWException(CloudEventRWExceptionKind.INVALID_EXTENSION_NAME, "Invalid extensions name: " + extensionName);
    }

    public static CloudEventRWException newInvalidAttributeType(String attributeName, Class<?> clazz) {
        return new CloudEventRWException(CloudEventRWExceptionKind.INVALID_ATTRIBUTE_TYPE, "Invalid attribute/extension type for \"" + attributeName + "\": " + clazz.getCanonicalName());
    }

    public static CloudEventRWException newInvalidAttributeType(String attributeName, Object value) {
        return new CloudEventRWException(CloudEventRWExceptionKind.INVALID_ATTRIBUTE_TYPE, "Invalid attribute/extension type for \"" + attributeName + "\": Type" + value.getClass().getCanonicalName() + ". Value: " + value);
    }

    public static CloudEventRWException newInvalidAttributeValue(String attributeName, Object value, @Nullable Throwable cause) {
        return new CloudEventRWException(CloudEventRWExceptionKind.INVALID_ATTRIBUTE_VALUE, "Invalid attribute/extension value for \"" + attributeName + "\": " + value, cause);
    }

    public static CloudEventRWException newInvalidDataType(String actual, String ... allowed) {
        String message = allowed.length == 0 ? "Invalid data type: " + actual : "Invalid data type: " + actual + ". Allowed: " + String.join((CharSequence)", ", allowed);
        return new CloudEventRWException(CloudEventRWExceptionKind.INVALID_DATA_TYPE, message);
    }

    public static CloudEventRWException newDataConversion(Throwable cause, String from, String to) {
        return new CloudEventRWException(CloudEventRWExceptionKind.DATA_CONVERSION, "Error while trying to convert data from " + from + " to " + to, cause);
    }

    public static CloudEventRWException newUnknownEncodingException() {
        return new CloudEventRWException(CloudEventRWExceptionKind.UNKNOWN_ENCODING, "Could not parse. Unknown encoding. Invalid content type or spec version");
    }

    public static CloudEventRWException newOther(Throwable cause) {
        return new CloudEventRWException(CloudEventRWExceptionKind.OTHER, cause);
    }

    public static enum CloudEventRWExceptionKind {
        INVALID_SPEC_VERSION,
        INVALID_ATTRIBUTE_NAME,
        INVALID_EXTENSION_NAME,
        INVALID_ATTRIBUTE_TYPE,
        INVALID_ATTRIBUTE_VALUE,
        INVALID_DATA_TYPE,
        DATA_CONVERSION,
        UNKNOWN_ENCODING,
        OTHER;

    }
}

