/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.serializers;

import io.confluent.shaded.com.google.common.collect.ImmutableList;
import io.confluent.shaded.com.google.gson.Gson;
import io.confluent.shaded.com.google.protobuf.Descriptors;
import io.confluent.shaded.com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.shaded.com.google.protobuf.Message;
import io.confluent.shaded.com.google.protobuf.util.JsonFormat;
import io.confluent.shaded.io.confluent.serializers.OrderedBytes;
import io.confluent.shaded.io.confluent.serializers.OrderedKeyUberSerde;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedKeyProtoSerde<T extends Message>
implements OrderedKeyUberSerde<T> {
    protected static final Logger log = LoggerFactory.getLogger(OrderedKeyProtoSerde.class);
    protected final T instance;
    protected final ImmutableList<Descriptors.FieldDescriptor> fields;
    protected static final int ENUM_FIELD_SIZE = 3;

    public static <T extends Message> OrderedKeyProtoSerde<T> create(T instance, int ... fieldNumbers) {
        Descriptors.Descriptor desc = instance.getDescriptorForType();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int fieldNumber : fieldNumbers) {
            builder.add(desc.findFieldByNumber(fieldNumber));
        }
        return new OrderedKeyProtoSerde<T>(instance, (ImmutableList<Descriptors.FieldDescriptor>)builder.build());
    }

    public static void readMagicByte(ByteBuffer buffer) {
        byte magic = buffer.get();
        if (126 != magic) {
            String errMsg = String.format("Tried to deserialize message with unknown magic byte %s", magic);
            log.error(errMsg);
            throw new SerializationException(errMsg);
        }
    }

    public static <T extends Message> T readProto(ByteBuffer buffer, T instance, ImmutableList<Descriptors.FieldDescriptor> fields) {
        Message.Builder builder = instance.newBuilderForType();
        block6: for (Descriptors.FieldDescriptor field : fields) {
            switch (field.getJavaType()) {
                case INT: {
                    builder.setField(field, OrderedBytes.readInt(buffer));
                    continue block6;
                }
                case LONG: {
                    builder.setField(field, OrderedBytes.readLong(buffer));
                    continue block6;
                }
                case STRING: {
                    builder.setField(field, OrderedBytes.readString(buffer));
                    continue block6;
                }
                case ENUM: {
                    Short enumNumber = OrderedBytes.readShort(buffer);
                    if (enumNumber == null) continue block6;
                    builder.setField(field, field.getEnumType().findValueByNumber(enumNumber.shortValue()));
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unexpected type: " + field.getJavaType().name());
        }
        return (T)builder.build();
    }

    public static void writeMagicByte(ByteBuffer buffer) {
        buffer.put((byte)126);
    }

    protected byte[] protoToBytes(T message, ImmutableList<Descriptors.FieldDescriptor> fields, int numFields) {
        if (message == null) {
            return null;
        }
        try {
            ByteBuffer buffer = ByteBuffer.allocate(OrderedKeyProtoSerde.getMaxSerializedBytes(message, fields));
            OrderedKeyProtoSerde.writeMagicByte(buffer);
            OrderedKeyProtoSerde.writeProto(buffer, message, fields, numFields);
            byte[] result = new byte[buffer.position()];
            buffer.flip();
            buffer.get(result, 0, result.length);
            return result;
        }
        catch (Exception e) {
            String errMsg = "Error serializing key message";
            log.error(errMsg, (Throwable)e);
            throw new SerializationException(errMsg, (Throwable)e);
        }
    }

    public static void writeProto(ByteBuffer buffer, Message message, ImmutableList<Descriptors.FieldDescriptor> fields, int numFields) {
        block6: for (int i = 0; i < numFields && i <= numFields; ++i) {
            Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)fields.get(i);
            switch (field.getJavaType()) {
                case INT: {
                    OrderedBytes.writeInt(buffer, (Integer)message.getField(field));
                    continue block6;
                }
                case LONG: {
                    OrderedBytes.writeLong(buffer, (Long)message.getField(field));
                    continue block6;
                }
                case STRING: {
                    OrderedBytes.writeString(buffer, (String)message.getField(field));
                    continue block6;
                }
                case ENUM: {
                    int enumNumber = ((Descriptors.EnumValueDescriptor)message.getField(field)).getNumber();
                    OrderedKeyProtoSerde.encodeEnum(buffer, enumNumber);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected type: " + field.getJavaType().name());
                }
            }
        }
    }

    public static void encodeEnum(ByteBuffer buffer, int enumVal) {
        if (enumVal > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Enum value is too large: " + enumVal);
        }
        OrderedBytes.writeShort(buffer, (short)enumVal);
    }

    public static int getMaxSerializedBytes(Message message, ImmutableList<Descriptors.FieldDescriptor> fields) {
        int size = 1;
        block6: for (Descriptors.FieldDescriptor field : fields) {
            switch (field.getJavaType()) {
                case INT: {
                    size += 5;
                    continue block6;
                }
                case LONG: {
                    size += 9;
                    continue block6;
                }
                case STRING: {
                    size += OrderedBytes.getMaxNumBytes((String)message.getField(field));
                    continue block6;
                }
                case ENUM: {
                    size += 3;
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unexpected type: " + field.getJavaType().name());
        }
        return size;
    }

    public static <T extends Message> T jsonToProto(String json, T instance) {
        Message.Builder builder = instance.newBuilderForType();
        try {
            JsonFormat.parser().merge(json, builder);
            return (T)builder.build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new SerializationException("JSON parsing failed", (Throwable)e);
        }
    }

    public static <T extends Message> String protoToJson(T message) {
        try {
            String json = JsonFormat.printer().print(message);
            Gson gson = new Gson();
            return gson.toJson(gson.fromJson(json, Object.class));
        }
        catch (InvalidProtocolBufferException e) {
            throw new SerializationException("JSON formatting failed", (Throwable)e);
        }
    }

    public OrderedKeyProtoSerde(T instance, ImmutableList<Descriptors.FieldDescriptor> fields) {
        this.instance = instance;
        this.fields = fields;
    }

    @Override
    public Class<Bytes> type() {
        return Bytes.class;
    }

    @Override
    public byte[] serialize(Bytes bytes) {
        return bytes.get();
    }

    public byte[] serialize(String topic, Bytes data) {
        return this.serialize(data);
    }

    public Bytes deserialize(String topic, byte[] data) {
        return this.deserialize(data);
    }

    @Override
    public Bytes deserialize(byte[] bytes) {
        return Bytes.wrap((byte[])bytes);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public void close() {
    }

    public Serializer<Bytes> serializer() {
        return this;
    }

    public Deserializer<Bytes> deserializer() {
        return this;
    }

    @Override
    public byte[] fromJson(String json) {
        T proto = OrderedKeyProtoSerde.jsonToProto(json, this.instance);
        return this.protoToBytes(proto, this.fields, this.fields.size());
    }

    @Override
    public String toJson(Bytes bytes) {
        Object obj = this.toProto(bytes);
        return OrderedKeyProtoSerde.protoToJson(obj);
    }

    @Override
    public OrderedKeyUberSerde<T> prefixKeySerde(int numFields) {
        if (numFields <= 0) {
            throw new IllegalArgumentException(String.format("Fields requested %d must be greater than zero", numFields));
        }
        if (numFields > this.fields.size()) {
            throw new IllegalArgumentException(String.format("Fields requested %d is higher than total %d", numFields, this.fields.size()));
        }
        return new OrderedKeyProtoSerde<T>(this.instance, (ImmutableList<Descriptors.FieldDescriptor>)this.fields.subList(0, numFields));
    }

    @Override
    public int numFields() {
        return this.fields.size();
    }

    @Override
    public Bytes key(T message) {
        return Bytes.wrap((byte[])this.protoToBytes(message, this.fields, this.fields.size()));
    }

    @Override
    public T toProto(Bytes key) {
        if (key == null) {
            return null;
        }
        try {
            ByteBuffer buffer = ByteBuffer.wrap(key.get());
            OrderedKeyProtoSerde.readMagicByte(buffer);
            return OrderedKeyProtoSerde.readProto(buffer, this.instance, this.fields);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            String errMsg = "Error deserializing key message";
            log.error(errMsg, (Throwable)e);
            throw new SerializationException(errMsg, (Throwable)e);
        }
    }

    @Override
    public String toHexString(Bytes key) {
        return DatatypeConverter.printHexBinary((byte[])key.get());
    }
}

