/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry;

import io.confluent.shaded.com.google.common.base.Preconditions;
import io.confluent.shaded.com.google.protobuf.Timestamp;
import io.confluent.shaded.io.opencensus.proto.metrics.v1.Metric;
import io.confluent.shaded.io.opencensus.proto.metrics.v1.MetricDescriptor;
import io.confluent.shaded.io.opencensus.proto.metrics.v1.Point;
import io.confluent.shaded.io.opencensus.proto.metrics.v1.TimeSeries;
import io.confluent.shaded.io.opencensus.proto.resource.v1.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MetricBuilderFacade
implements Cloneable {
    private final Metric.Builder metricBuilder;
    private final Map<String, String> labels;

    public MetricBuilderFacade() {
        this(Metric.newBuilder());
    }

    private MetricBuilderFacade(Metric.Builder metricBuilder) {
        this.metricBuilder = metricBuilder;
        this.labels = new HashMap<String, String>();
    }

    public Map<String, String> getLabels() {
        return Collections.unmodifiableMap(this.labels);
    }

    public MetricBuilderFacade withResource(Resource resource) {
        this.metricBuilder.setResource(resource);
        return this;
    }

    public MetricBuilderFacade withLabel(String key, String value) {
        this.labels.put(key, value);
        return this;
    }

    public MetricBuilderFacade withLabels(Map<String, String> labels) {
        this.labels.putAll(labels);
        return this;
    }

    public MetricBuilderFacade withName(String name) {
        this.metricBuilder.getMetricDescriptorBuilder().setName(name);
        return this;
    }

    public MetricBuilderFacade withType(MetricDescriptor.Type type) {
        this.metricBuilder.getMetricDescriptorBuilder().setType(type);
        return this;
    }

    public MetricBuilderFacade addSinglePointTimeseries(Point point) {
        return this.addSinglePointTimeseries(point, null);
    }

    public MetricBuilderFacade addSinglePointTimeseries(Point point, Timestamp startTimestamp) {
        TimeSeries.Builder timeseries = this.metricBuilder.addTimeseriesBuilder().addPoints(point);
        if (startTimestamp != null) {
            timeseries.setStartTimestamp(startTimestamp);
        }
        return this;
    }

    public Metric build() {
        this.validate();
        for (Map.Entry<String, String> label : this.labels.entrySet()) {
            this.metricBuilder.getMetricDescriptorBuilder().addLabelKeysBuilder().setKey(label.getKey());
            for (TimeSeries.Builder timeseries : this.metricBuilder.getTimeseriesBuilderList()) {
                timeseries.addLabelValuesBuilder().setValue(label.getValue());
            }
        }
        return this.metricBuilder.build();
    }

    private void validate() {
        Preconditions.checkState(this.metricBuilder.hasResource(), "Metric Resource must be set");
    }

    public MetricBuilderFacade clone() {
        return new MetricBuilderFacade(this.metricBuilder.clone()).withLabels(this.labels);
    }
}

