/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.client;

import io.confluent.shaded.com.google.common.base.Preconditions;
import io.confluent.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.confluent.shaded.com.google.protobuf.MessageLite;
import io.confluent.shaded.io.confluent.telemetry.client.BufferingAsyncClient;
import io.confluent.shaded.io.confluent.telemetry.client.BufferingAsyncTelemetryHttpClientBatch;
import io.confluent.shaded.io.confluent.telemetry.client.BufferingAsyncTelemetryHttpClientBatchResult;
import io.confluent.shaded.io.confluent.telemetry.client.BufferingAsyncTelemetryHttpClientStats;
import io.confluent.shaded.io.confluent.telemetry.client.BufferingAsyncTelemetryHttpClientStatsCollector;
import io.confluent.shaded.io.confluent.telemetry.client.TelemetryHttpClient;
import io.confluent.shaded.io.reactivex.BackpressureOverflowStrategy;
import io.confluent.shaded.io.reactivex.BackpressureStrategy;
import io.confluent.shaded.io.reactivex.Flowable;
import io.confluent.shaded.io.reactivex.Observable;
import io.confluent.shaded.io.reactivex.Scheduler;
import io.confluent.shaded.io.reactivex.Single;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.schedulers.Schedulers;
import io.confluent.shaded.io.reactivex.subjects.PublishSubject;
import io.confluent.shaded.io.reactivex.subjects.Subject;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferingAsyncTelemetryHttpClient<T, S extends MessageLite, R>
implements BufferingAsyncClient<T, R> {
    public static final Duration DEFAULT_MAX_BATCH_DURATION = Duration.ofSeconds(5L);
    public static final int DEFAULT_MAX_BATCH_SIZE = 1000;
    public static final int DEFAULT_MAX_PENDING_BATCHES = 10;
    public static final int DEFAULT_MAX_INFLIGHT_SUBMISSIONS = 1;
    public static final Scheduler DEFAULT_SCHEDULER = Schedulers.from(Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("buffering-async-telemetry-http-client-%d").build()));
    private static final Logger logger = LoggerFactory.getLogger(BufferingAsyncTelemetryHttpClient.class);
    private final Subject<T> incomingSubject;
    private final Flowable<BufferingAsyncTelemetryHttpClientBatchResult<T, R>> statusFlowable;
    private final Disposable subscription;
    private final Duration maxBatchDuration;
    private final int maxBatchSize;
    private final TelemetryHttpClient<S, R> client;
    private final Scheduler scheduler;
    private final int maxPendingBatches;
    private final int maxInflightSubmissions;
    private final Function<Collection<T>, S> createRequestFn;
    private final BufferingAsyncTelemetryHttpClientStatsCollector statsCollector = new BufferingAsyncTelemetryHttpClientStatsCollector();

    private BufferingAsyncTelemetryHttpClient(Builder<T, S, R> builder) {
        this.client = ((Builder)builder).client;
        this.scheduler = ((Builder)builder).scheduler;
        this.maxBatchDuration = ((Builder)builder).maxBatchDuration;
        this.maxBatchSize = ((Builder)builder).maxBatchSize;
        this.maxPendingBatches = ((Builder)builder).maxPendingBatches;
        this.maxInflightSubmissions = ((Builder)builder).maxInflightSubmissions;
        this.createRequestFn = ((Builder)builder).createRequestFn;
        this.incomingSubject = PublishSubject.create().toSerialized();
        logger.debug("Creating {} with args: maxBatchDurationMs[{}], maxBatchSize[{}], maxPendingBatches[{}],maxInflightSubmissions[{}]", new Object[]{BufferingAsyncTelemetryHttpClient.class.getSimpleName(), this.maxBatchDuration.toMillis(), this.maxBatchSize, this.maxPendingBatches, this.maxInflightSubmissions});
        Flowable<BufferingAsyncTelemetryHttpClientBatch> batches = this.incomingSubject.buffer(this.maxBatchDuration.toMillis(), TimeUnit.MILLISECONDS, this.scheduler, this.maxBatchSize).filter(batch -> batch.size() > 0).map(items -> {
            long batchId = this.statsCollector.recordBatch(items.size());
            return new BufferingAsyncTelemetryHttpClientBatch(batchId, items);
        }).toFlowable(BackpressureStrategy.MISSING).onBackpressureBuffer((long)this.maxPendingBatches, () -> {
            this.statsCollector.recordDroppedBatch();
            logger.debug("Dropping batch due to backpressure.");
        }, BackpressureOverflowStrategy.DROP_OLDEST);
        this.statusFlowable = batches.flatMapSingle(batch -> {
            Instant sendStart = Instant.now();
            long batchId = batch.getBatchId();
            List items = batch.getItems();
            MessageLite request = (MessageLite)this.createRequestFn.apply(items);
            return this.client.submit(request).map(response -> {
                this.statsCollector.recordSuccessfulBatch(items.size(), sendStart);
                return new BufferingAsyncTelemetryHttpClientBatchResult(batch, Duration.between(sendStart, Instant.now()), response, null);
            }).onErrorResumeNext(error -> {
                this.statsCollector.recordFailedBatch(items.size(), sendStart);
                logger.debug(String.format("Failed to submit batch %s", batchId), error);
                return Single.just(new BufferingAsyncTelemetryHttpClientBatchResult(batch, Duration.between(sendStart, Instant.now()), null, (Throwable)error));
            });
        }, false, this.maxInflightSubmissions).share();
        this.subscription = this.statusFlowable.subscribe();
    }

    public static <T, S extends MessageLite, R> Builder<T, S, R> newBuilder() {
        return new Builder();
    }

    @Override
    public void submit(Collection<T> items) {
        items.forEach(this.incomingSubject::onNext);
    }

    @Override
    public Observable<BufferingAsyncTelemetryHttpClientBatchResult<T, R>> getBatchResults() {
        return this.statusFlowable.toObservable();
    }

    @Override
    public BufferingAsyncTelemetryHttpClientStats stats() {
        return this.statsCollector.snapshot();
    }

    @Override
    public void close() throws IOException {
        this.incomingSubject.onComplete();
        this.subscription.dispose();
        this.client.close();
    }

    public static final class Builder<T, S extends MessageLite, R> {
        private Scheduler scheduler = DEFAULT_SCHEDULER;
        private Duration maxBatchDuration = DEFAULT_MAX_BATCH_DURATION;
        private int maxBatchSize = 1000;
        private TelemetryHttpClient<S, R> client;
        private int maxPendingBatches = 10;
        private int maxInflightSubmissions = 1;
        private Function<Collection<T>, S> createRequestFn;

        private Builder() {
        }

        public Builder<T, S, R> setMaxBatchDuration(Duration maxBatchDuration) {
            Preconditions.checkArgument(maxBatchDuration.toMillis() > 0L);
            this.maxBatchDuration = maxBatchDuration;
            return this;
        }

        public Builder<T, S, R> setMaxBatchSize(int maxBatchSize) {
            Preconditions.checkArgument(maxBatchSize > 0);
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public Builder<T, S, R> setClient(TelemetryHttpClient<S, R> client) {
            Preconditions.checkNotNull(client);
            this.client = client;
            return this;
        }

        public Builder<T, S, R> setScheduler(Scheduler scheduler) {
            Preconditions.checkNotNull(scheduler);
            this.scheduler = scheduler;
            return this;
        }

        public Builder<T, S, R> setMaxPendingBatches(int maxPendingBatches) {
            Preconditions.checkArgument(maxPendingBatches > 0);
            this.maxPendingBatches = maxPendingBatches;
            return this;
        }

        public Builder<T, S, R> setMaxInflightSubmissions(int maxInflightSubmissions) {
            Preconditions.checkArgument(maxInflightSubmissions > 0);
            this.maxInflightSubmissions = maxInflightSubmissions;
            return this;
        }

        public Builder<T, S, R> setCreateRequestFn(Function<Collection<T>, S> createRequestFn) {
            this.createRequestFn = createRequestFn;
            return this;
        }

        public BufferingAsyncTelemetryHttpClient<T, S, R> build() {
            Preconditions.checkState(this.client != null, "Must specify a client when building %s", BufferingAsyncTelemetryHttpClient.class);
            Preconditions.checkState(this.createRequestFn != null, "Must specify a createRequestFn when building %s", BufferingAsyncTelemetryHttpClient.class);
            return new BufferingAsyncTelemetryHttpClient(this);
        }
    }
}

