/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.client;

import io.confluent.shaded.io.confluent.telemetry.client.Compressor;
import io.confluent.shaded.io.confluent.telemetry.client.GzipCompressor;
import io.confluent.shaded.io.confluent.telemetry.client.Lz4Compressor;
import io.confluent.shaded.io.confluent.telemetry.client.NoneCompressor;
import io.confluent.shaded.io.confluent.telemetry.client.ZstdCompressor;

public enum CompressionAlgorithm {
    GZIP{

        @Override
        Compressor createCompressor() {
            return new GzipCompressor();
        }
    }
    ,
    LZ4{

        @Override
        Compressor createCompressor() {
            return new Lz4Compressor();
        }
    }
    ,
    ZSTD{

        @Override
        Compressor createCompressor() {
            return new ZstdCompressor();
        }
    }
    ,
    NONE{

        @Override
        Compressor createCompressor() {
            return new NoneCompressor();
        }
    };


    abstract Compressor createCompressor();
}

