/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.config;

import io.confluent.shaded.com.google.common.cache.CacheBuilder;
import io.confluent.shaded.com.google.common.cache.CacheLoader;
import io.confluent.shaded.com.google.common.cache.LoadingCache;
import io.confluent.shaded.com.google.common.collect.Maps;
import io.confluent.shaded.io.confluent.telemetry.config.AdvancedNameFilter;
import io.confluent.shaded.io.confluent.telemetry.config.AttributeRule;
import io.confluent.shaded.io.confluent.telemetry.config.ExactMetricRule;
import io.confluent.shaded.io.confluent.telemetry.config.PatternMetricRule;
import io.confluent.telemetry.metrics.Keyed;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

class AdvancedFilterPredicate
implements Predicate<Keyed> {
    private final Map<String, ExactMetricRule> exactRules;
    private final LoadingCache<String, Optional<PatternMetricRule>> patternMatchCache;

    AdvancedFilterPredicate(AdvancedNameFilter filter) {
        this.exactRules = Maps.uniqueIndex(filter.getIncludeRules().getExactRules(), ExactMetricRule::getName);
        this.patternMatchCache = Optional.ofNullable(filter.getIncludeRules().getPatternRules()).map(patternRules -> CacheBuilder.newBuilder().maximumSize(5000L).concurrencyLevel(1).build(AdvancedFilterPredicate.newCacheLoader(patternRules))).orElse(null);
    }

    @Override
    public boolean test(Keyed keyed) {
        String metricName = keyed.key().getName();
        Map<String, String> attributes = keyed.key().getLabels();
        ExactMetricRule matchedExactRule = this.exactRules.get(metricName);
        if (matchedExactRule != null) {
            return this.testAttributes(matchedExactRule.getAttributeRules(), attributes);
        }
        if (this.patternMatchCache == null) {
            return false;
        }
        Optional<PatternMetricRule> matchedPatternRule = this.patternMatchCache.getUnchecked(metricName);
        if (matchedPatternRule.isPresent()) {
            return this.testAttributes(matchedPatternRule.get().getAttributeRules(), attributes);
        }
        return false;
    }

    public boolean testAttributes(List<AttributeRule> rules, Map<String, String> attributes) {
        for (AttributeRule rule : rules) {
            String dataPointAttribute = attributes.get(rule.getKey());
            if (dataPointAttribute != null && rule.getValues().contains(dataPointAttribute)) continue;
            return false;
        }
        return true;
    }

    private static CacheLoader<String, Optional<PatternMetricRule>> newCacheLoader(final List<PatternMetricRule> patternRules) {
        return new CacheLoader<String, Optional<PatternMetricRule>>(){

            @Override
            public Optional<PatternMetricRule> load(String metricName) throws Exception {
                for (PatternMetricRule patternRule : patternRules) {
                    if (!patternRule.getName().matcher(metricName).matches()) continue;
                    return Optional.of(patternRule);
                }
                return Optional.empty();
            }
        };
    }
}

