/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.config;

import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.shaded.com.google.common.base.Preconditions;
import io.confluent.shaded.com.google.common.collect.Sets;
import io.confluent.shaded.io.confluent.telemetry.config.NamedFilter;
import io.confluent.shaded.io.confluent.telemetry.config.NamedPredicate;
import io.confluent.telemetry.metrics.Keyed;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class FilterSetPredicate
implements Predicate<Keyed> {
    private final Set<NamedPredicate> filters;

    public static FilterSetPredicate fromNamedFilter(NamedFilter filter) {
        return FilterSetPredicate.fromNamedFilter(Collections.singleton(Objects.requireNonNull(filter, "Filter can't be null")));
    }

    public static FilterSetPredicate fromNamedFilter(Set<NamedFilter> filters) {
        Preconditions.checkNotNull(filters, "Filters can't be null");
        return new FilterSetPredicate(filters.stream().map(NamedPredicate::fromNamedFilter).collect(Collectors.toSet()));
    }

    private FilterSetPredicate(Set<NamedPredicate> filters) {
        this.filters = filters;
    }

    @VisibleForTesting
    Set<NamedPredicate> getFilters() {
        return this.filters;
    }

    public FilterSetPredicate subset(Set<String> filterNames) {
        Set<NamedPredicate> selectedFilters = this.filters.stream().filter(f -> filterNames.contains(f.getName())).collect(Collectors.toSet());
        if (selectedFilters.size() != filterNames.size()) {
            Set existingFilters = this.filters.stream().map(NamedPredicate::getName).collect(Collectors.toSet());
            String missing = filterNames.stream().filter(f -> !existingFilters.contains(f)).findFirst().get();
            throw new NoSuchElementException(String.format("Filter '%s' does not exist.", missing));
        }
        return new FilterSetPredicate(selectedFilters);
    }

    public FilterSetPredicate union(FilterSetPredicate other) {
        Set currentFiltersNames = this.filters.stream().map(NamedPredicate::getName).collect(Collectors.toSet());
        Set newAdditions = other.filters.stream().filter(f -> !currentFiltersNames.contains(f.getName())).collect(Collectors.toSet());
        return new FilterSetPredicate(Sets.union(this.filters, newAdditions));
    }

    @Override
    public boolean test(Keyed key) {
        for (NamedPredicate filter : this.filters) {
            if (!filter.test(key)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterSetPredicate that = (FilterSetPredicate)o;
        return this.filters.equals(that.filters);
    }

    public int hashCode() {
        return Objects.hash(this.filters);
    }
}

