/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.config.remote;

import io.confluent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.confluent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.shaded.com.google.common.base.Preconditions;
import io.confluent.shaded.io.opentelemetry.proto.common.v1.AnyValue;
import io.confluent.shaded.io.opentelemetry.proto.common.v1.KeyValue;
import io.confluent.shaded.io.opentelemetry.proto.resource.v1.Resource;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class RemoteConfigurationRequest {
    private final Resource resource;

    @JsonCreator
    public RemoteConfigurationRequest(@JsonProperty(value="resource") Resource resource) {
        Objects.requireNonNull(resource, "resource can't be null");
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    private RemoteConfigurationRequest(Builder builder) {
        this.resource = builder.resource;
    }

    public static class Builder {
        Resource resource;

        public Builder withResourceAttributes(Map<String, String> attributes) {
            Preconditions.checkState(attributes != null && !attributes.isEmpty(), "Resource Attributes must not be empty");
            this.resource = Resource.newBuilder().addAllAttributes(attributes.entrySet().stream().map(entry -> KeyValue.newBuilder().setKey((String)entry.getKey()).setValue(AnyValue.newBuilder().setStringValue((String)entry.getValue())).build()).collect(Collectors.toSet())).build();
            return this;
        }

        public RemoteConfigurationRequest build() {
            Preconditions.checkNotNull(this.resource, "Resource must not be null");
            return new RemoteConfigurationRequest(this);
        }
    }
}

