/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.config.remote.polling;

import io.confluent.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.confluent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.shaded.com.hubspot.jackson.datatype.protobuf.ProtobufModule;
import io.confluent.shaded.io.confluent.telemetry.client.Credentials;
import io.confluent.shaded.io.confluent.telemetry.client.ProxyConfig;
import io.confluent.shaded.io.confluent.telemetry.client.TelemetryHttpClient;
import io.confluent.shaded.io.confluent.telemetry.client.TelemetryHttpResponse;
import io.confluent.shaded.io.confluent.telemetry.config.remote.RemoteConfigurationRequest;
import io.confluent.shaded.io.confluent.telemetry.config.remote.RemoteConfigurationResponse;
import io.confluent.shaded.io.confluent.telemetry.config.remote.polling.PollingRemoteConfigurationSource;
import io.confluent.shaded.io.confluent.telemetry.config.remote.v1.RemoteConfiguration;
import io.confluent.shaded.io.opentelemetry.proto.resource.v1.Resource;
import io.confluent.shaded.io.reactivex.Single;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class HttpRemoteConfigurationSource
extends PollingRemoteConfigurationSource {
    private static final String CONTENT_TYPE = "application/json";
    @VisibleForTesting
    public static final String V1_CONFIGURATION_ENDPOINT = "/v1/config";
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule(new ProtobufModule());
    private final Resource resource;
    private final TelemetryHttpClient<RemoteConfigurationRequest, RemoteConfigurationResponse> httpClient;
    private volatile Credentials credentials;
    private volatile ProxyConfig proxyConfig;
    private RemoteConfigurationResponse latestResponse;

    public HttpRemoteConfigurationSource(TelemetryHttpClient.Builder<RemoteConfigurationRequest, RemoteConfigurationResponse> builder, long refreshIntervalMs, Consumer<RemoteConfiguration> callback, Resource resource) {
        super(refreshIntervalMs, callback);
        this.resource = resource;
        this.httpClient = builder.setEndpoint(V1_CONFIGURATION_ENDPOINT).setContentType(CONTENT_TYPE).setAcceptType(CONTENT_TYPE).setRequestSerializer(this.mapper::writeValue).setResponseDeserializer(bytes -> this.mapper.readValue(bytes.array(), RemoteConfigurationResponse.class)).setCredentialsSupplier(() -> this.credentials).setProxyConfigSupplier(() -> this.proxyConfig).build();
    }

    @Override
    public void stop() {
        super.stop();
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected Optional<RemoteConfiguration> requestConfig() {
        if (this.credentials == null) {
            return Optional.empty();
        }
        Single<TelemetryHttpResponse<RemoteConfigurationResponse>> result = this.httpClient.submit(new RemoteConfigurationRequest(this.resource));
        RemoteConfigurationResponse response = result.blockingGet().getResponseBody();
        if (!(response.getChecksum() == null || this.latestResponse != null && Objects.equals(response.getChecksum(), this.latestResponse.getChecksum()))) {
            this.latestResponse = response;
            return Optional.ofNullable(response.getConfig());
        }
        return Optional.empty();
    }

    @VisibleForTesting
    void setLatestResponse(RemoteConfigurationResponse response) {
        this.latestResponse = response;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }
}

