/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.config.remote.polling.kubernetes;

import io.confluent.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.confluent.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.confluent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.shaded.com.google.common.annotations.VisibleForTesting;
import io.confluent.shaded.io.confluent.telemetry.config.remote.polling.PollingRemoteConfigurationSource;
import io.confluent.shaded.io.confluent.telemetry.config.remote.polling.kubernetes.ConfigSet;
import io.confluent.shaded.io.confluent.telemetry.config.remote.polling.kubernetes.KubernetesConfigMapRemoteConfigurationConfig;
import io.confluent.shaded.io.confluent.telemetry.config.remote.polling.kubernetes.V1ConfigMap;
import io.confluent.shaded.io.confluent.telemetry.config.remote.v1.RemoteConfiguration;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesConfigMapRemoteConfigurationSource
extends PollingRemoteConfigurationSource {
    private static final Logger log = LoggerFactory.getLogger(KubernetesConfigMapRemoteConfigurationSource.class);
    private static final String KUBERNETES_SERVICE_HOST_ENV_VAR = "KUBERNETES_SERVICE_HOST";
    private static final String KUBERNETES_SERVICE_PORT_ENV_VAR = "KUBERNETES_SERVICE_PORT";
    private static final String SERVICE_ACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private static final String CERTIFICATE_AUTHORITY = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    private static final String REPORTER_VERSION = RemoteConfiguration.getSchemaVersion();
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, true).configure(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES, true);
    private String latestResourceVersion;
    private final List<URL> endpoints;
    private final SSLSocketFactory sslSocketFactory;
    private String serviceAccountToken;

    public KubernetesConfigMapRemoteConfigurationSource(KubernetesConfigMapRemoteConfigurationConfig config, Optional<String> physicalClusterId, Consumer<RemoteConfiguration> callback) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        super(config.getRefreshInterval(), callback);
        ArrayList<URL> endpoints = new ArrayList<URL>();
        if (physicalClusterId.isPresent()) {
            endpoints.add(new URL(KubernetesConfigMapRemoteConfigurationSource.parseEndpointFromEnv(config, physicalClusterId.get())));
        }
        endpoints.add(new URL(KubernetesConfigMapRemoteConfigurationSource.parseDefaultEndpointFromEnv(config)));
        this.endpoints = endpoints;
        this.sslSocketFactory = KubernetesConfigMapRemoteConfigurationSource.buildSSLSocketFactory();
        this.serviceAccountToken = KubernetesConfigMapRemoteConfigurationSource.getKubeServiceAccountToken();
    }

    @VisibleForTesting
    KubernetesConfigMapRemoteConfigurationSource(KubernetesConfigMapRemoteConfigurationConfig config, List<URL> endpoints, Consumer<RemoteConfiguration> callback) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        super(config.getRefreshInterval(), callback);
        this.endpoints = endpoints;
        this.sslSocketFactory = KubernetesConfigMapRemoteConfigurationSource.buildSSLSocketFactory();
        this.serviceAccountToken = KubernetesConfigMapRemoteConfigurationSource.getKubeServiceAccountToken();
    }

    @VisibleForTesting
    static SSLSocketFactory buildSSLSocketFactory() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        try (BufferedInputStream caInput = new BufferedInputStream(Files.newInputStream(Paths.get(CERTIFICATE_AUTHORITY, new String[0]), new OpenOption[0]));){
            CertificateFactory ca = CertificateFactory.getInstance("X.509");
            int certificateNumber = 0;
            while (((InputStream)caInput).available() > 0) {
                keyStore.setCertificateEntry("ca" + certificateNumber, ca.generateCertificate(caInput));
                ++certificateNumber;
            }
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, tmf.getTrustManagers(), null);
        return context.getSocketFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Optional<RemoteConfiguration> requestConfig() {
        Iterator<URL> iterator = this.endpoints.iterator();
        block25: while (iterator.hasNext()) {
            URL endpoint = iterator.next();
            try {
                Throwable throwable;
                InputStream is;
                HttpURLConnection connection = (HttpURLConnection)endpoint.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Authorization", "Bearer " + this.serviceAccountToken);
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslSocketFactory);
                int responseCode = connection.getResponseCode();
                switch (responseCode) {
                    case 404: {
                        continue block25;
                    }
                    case 200: {
                        is = connection.getInputStream();
                        throwable = null;
                        try {
                            Optional<RemoteConfiguration> optional = this.validateConfigResponse(this.mapper.readValue(is, V1ConfigMap.class));
                            return optional;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                        }
                    }
                    case 401: {
                        this.serviceAccountToken = KubernetesConfigMapRemoteConfigurationSource.getKubeServiceAccountToken();
                        log.warn("Auth denied for ConfigMap. Refreshing service account token.");
                        return Optional.empty();
                    }
                }
                is = connection.getErrorStream();
                throwable = null;
                try {
                    log.error("Error querying for ConfigMap. Status code: {} with body: {}", (Object)responseCode, (Object)new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                log.error("Error configuring connection to Kube API Server: " + e);
            }
        }
        return Optional.empty();
    }

    private Optional<RemoteConfiguration> validateConfigResponse(V1ConfigMap configMap) {
        if (!(configMap.getMetadata().getResourceVersion() == null || this.latestResourceVersion != null && Objects.equals(configMap.getMetadata().getResourceVersion(), this.latestResourceVersion))) {
            try {
                Optional<RemoteConfiguration> config = ConfigSet.parseConfigYaml(Objects.requireNonNull(configMap.getData()).get("configs")).getCompatibleConfigVersion(REPORTER_VERSION);
                this.latestResourceVersion = configMap.getMetadata().getResourceVersion();
                log.info("Propagating configmap: " + configMap.getMetadata().getName());
                return config;
            }
            catch (JsonProcessingException e) {
                log.error("Can't parse configmap yaml", (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static String parseEndpointFromEnv(KubernetesConfigMapRemoteConfigurationConfig config, String configMapName) {
        String path = "/api/v1/namespaces/" + config.getNamespace() + "/configmaps/" + configMapName;
        String kubeServiceHost = System.getenv(KUBERNETES_SERVICE_HOST_ENV_VAR);
        if (Objects.isNull(kubeServiceHost)) {
            return "https://kubernetes.default.svc" + path;
        }
        return "https://" + kubeServiceHost + ":" + System.getenv(KUBERNETES_SERVICE_PORT_ENV_VAR) + path;
    }

    public static String parseDefaultEndpointFromEnv(KubernetesConfigMapRemoteConfigurationConfig config) {
        return KubernetesConfigMapRemoteConfigurationSource.parseEndpointFromEnv(config, config.getConfigMapNameConfig());
    }

    @VisibleForTesting
    static String getKubeServiceAccountToken() throws IOException {
        return new String(Files.readAllBytes(Paths.get(SERVICE_ACCOUNT_TOKEN_PATH, new String[0])));
    }

    @VisibleForTesting
    void setLatestResourceVersion(String resourceVersion) {
        this.latestResourceVersion = resourceVersion;
    }
}

