/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.confluent.telemetry.config.remote.v1;

import io.confluent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.confluent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.confluent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.shaded.io.confluent.telemetry.config.NamedFilter;
import io.confluent.shaded.io.confluent.telemetry.config.remote.ExporterConfig;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RemoteConfiguration {
    private static final String schemaVersion = "2.1";
    private final Set<String> activeFilters;
    private final Set<NamedFilter> filters;
    private final Set<ExporterConfig> exporters;

    public RemoteConfiguration() {
        this(Collections.emptySet(), Collections.singleton("_default"), null);
    }

    @JsonCreator
    public RemoteConfiguration(@JsonProperty(value="filters") Set<NamedFilter> filters, @JsonProperty(value="activeFilters") Set<String> activeFilters, @JsonProperty(value="exporters") Set<ExporterConfig> exporters) {
        this.filters = filters == null ? Collections.emptySet() : filters;
        this.activeFilters = activeFilters == null ? Collections.singleton("_default") : activeFilters;
        this.exporters = exporters == null ? Collections.emptySet() : exporters;
    }

    public Set<String> getActiveFilters() {
        return this.activeFilters;
    }

    public Set<NamedFilter> getFilters() {
        return this.filters;
    }

    public Set<ExporterConfig> getExporters() {
        return this.exporters;
    }

    @JsonIgnore
    public Map<String, ExporterConfig> getExporterConfigMap() {
        return this.exporters.stream().collect(Collectors.toMap(ExporterConfig::getName, Function.identity()));
    }

    @JsonIgnore
    public static String getSchemaVersion() {
        return schemaVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteConfiguration)) {
            return false;
        }
        RemoteConfiguration that = (RemoteConfiguration)o;
        return Objects.equals(this.activeFilters, that.activeFilters) && Objects.equals(this.filters, that.filters) && Objects.equals(this.exporters, that.exporters);
    }

    public int hashCode() {
        return Objects.hash(this.activeFilters, this.filters, this.exporters);
    }
}

